/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet;

import com.fasterxml.jackson.databind.SequenceWriter;
import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.builder.CliBuilder;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.druid.data.input.parquet.simple.ParquetGroupConverter;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;

@Command(name="ParquetToJson")
public class ParquetToJson
implements Callable<Void> {
    @Option(name={"--convert-corrupt-dates"})
    public boolean convertCorruptDates = false;
    @Arguments(description="directory")
    public List<String> directories;

    public static void main(String[] args) throws Exception {
        CliBuilder builder = Cli.builder((String)"ParquetToJson");
        builder.withDefaultCommand(ParquetToJson.class);
        ((Callable)builder.build().parse(args)).call();
    }

    private File[] getInputFiles() {
        if (this.directories == null || this.directories.size() != 1) {
            throw new IAE("Only one directory argument is supported!", new Object[0]);
        }
        File dir = new File(this.directories.get(0));
        if (!dir.isDirectory()) {
            throw new IAE("Not a directory [%s]", new Object[]{dir});
        }
        File[] inputFiles = dir.listFiles(pathname -> pathname.getName().endsWith(".parquet"));
        if (inputFiles == null || inputFiles.length == 0) {
            throw new IAE("No parquet files in directory [%s]", new Object[]{dir});
        }
        return inputFiles;
    }

    @Override
    public Void call() throws Exception {
        File[] inputFiles;
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        for (File inputFile : inputFiles = this.getInputFiles()) {
            File outputFile = new File(inputFile.getAbsolutePath() + ".json");
            try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(inputFile.toURI())).build();
                 SequenceWriter writer = mapper.writer().withRootValueSeparator("\n").writeValues(outputFile);){
                Group group;
                ParquetGroupConverter converter = new ParquetGroupConverter(true, this.convertCorruptDates);
                while ((group = (Group)reader.read()) != null) {
                    writer.write(converter.convertGroup(group));
                }
            }
        }
        return null;
    }
}

