/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import java.nio.ByteBuffer;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramFoldingBufferAggregatorHelper;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class ApproximateHistogramFoldingBufferAggregator
implements BufferAggregator {
    private final BaseObjectColumnValueSelector<ApproximateHistogram> selector;
    private final ApproximateHistogramFoldingBufferAggregatorHelper innerAggregator;

    public ApproximateHistogramFoldingBufferAggregator(BaseObjectColumnValueSelector<ApproximateHistogram> selector, int resolution, float lowerLimit, float upperLimit) {
        this.selector = selector;
        this.innerAggregator = new ApproximateHistogramFoldingBufferAggregatorHelper(resolution, lowerLimit, upperLimit);
    }

    public void init(ByteBuffer buf, int position) {
        this.innerAggregator.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position) {
        ApproximateHistogram hNext = (ApproximateHistogram)this.selector.getObject();
        this.innerAggregator.aggregate(buf, position, hNext);
    }

    public Object get(ByteBuffer buf, int position) {
        return this.innerAggregator.get(buf, position);
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramFoldingBufferAggregator does not support getFloat()");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramFoldingBufferAggregator does not support getLong()");
    }

    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramFoldingBufferAggregator does not support getDouble()");
    }

    public void close() {
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

