/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.indexing.seekablestream.SeekableStreamEndSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskIOConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.joda.time.DateTime;

public class KinesisIndexTaskIOConfig
extends SeekableStreamIndexTaskIOConfig<String, String> {
    public static final int DEFAULT_FETCH_DELAY_MILLIS = 0;
    public static final int MAX_RECORD_FETCH_MEMORY = 100000000;
    public static final double RECORD_FETCH_MEMORY_MAX_HEAP_FRACTION = 0.05;
    private final String endpoint;
    private final int fetchDelayMillis;
    private final String awsAssumedRoleArn;
    private final String awsExternalId;

    @JsonCreator
    public KinesisIndexTaskIOConfig(@JsonProperty(value="taskGroupId") @Nullable Integer taskGroupId, @JsonProperty(value="baseSequenceName") String baseSequenceName, @JsonProperty(value="startPartitions") @Nullable @Deprecated SeekableStreamEndSequenceNumbers<String, String> startPartitions, @JsonProperty(value="endPartitions") @Nullable @Deprecated SeekableStreamEndSequenceNumbers<String, String> endPartitions, @JsonProperty(value="exclusiveStartSequenceNumberPartitions") @Nullable @Deprecated Set<String> exclusiveStartSequenceNumberPartitions, @JsonProperty(value="startSequenceNumbers") SeekableStreamStartSequenceNumbers<String, String> startSequenceNumbers, @JsonProperty(value="endSequenceNumbers") SeekableStreamEndSequenceNumbers<String, String> endSequenceNumbers, @JsonProperty(value="useTransaction") Boolean useTransaction, @JsonProperty(value="minimumMessageTime") DateTime minimumMessageTime, @JsonProperty(value="maximumMessageTime") DateTime maximumMessageTime, @JsonProperty(value="inputFormat") @Nullable InputFormat inputFormat, @JsonProperty(value="endpoint") String endpoint, @JsonProperty(value="fetchDelayMillis") Integer fetchDelayMillis, @JsonProperty(value="awsAssumedRoleArn") String awsAssumedRoleArn, @JsonProperty(value="awsExternalId") String awsExternalId, @JsonProperty(value="refreshRejectionPeriodsInMinutes") Long refreshRejectionPeriodsInMinutes) {
        super(taskGroupId, baseSequenceName, KinesisIndexTaskIOConfig.getStartSequenceNumbers(startSequenceNumbers, startPartitions, exclusiveStartSequenceNumberPartitions), endSequenceNumbers == null ? endPartitions : endSequenceNumbers, useTransaction, minimumMessageTime, maximumMessageTime, inputFormat, refreshRejectionPeriodsInMinutes);
        Preconditions.checkArgument((boolean)this.getEndSequenceNumbers().getPartitionSequenceNumberMap().values().stream().noneMatch(x -> x.equals("EOS")), (Object)"End sequenceNumbers must not have the end of shard marker (EOS)");
        this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"endpoint");
        this.fetchDelayMillis = fetchDelayMillis != null ? fetchDelayMillis : 0;
        this.awsAssumedRoleArn = awsAssumedRoleArn;
        this.awsExternalId = awsExternalId;
    }

    public KinesisIndexTaskIOConfig(int taskGroupId, String baseSequenceName, SeekableStreamStartSequenceNumbers<String, String> startSequenceNumbers, SeekableStreamEndSequenceNumbers<String, String> endSequenceNumbers, Boolean useTransaction, DateTime minimumMessageTime, DateTime maximumMessageTime, InputFormat inputFormat, String endpoint, Integer fetchDelayMillis, String awsAssumedRoleArn, String awsExternalId, Long refreshRejectionPeriodsInMinutes) {
        this(taskGroupId, baseSequenceName, null, null, null, startSequenceNumbers, endSequenceNumbers, useTransaction, minimumMessageTime, maximumMessageTime, inputFormat, endpoint, fetchDelayMillis, awsAssumedRoleArn, awsExternalId, refreshRejectionPeriodsInMinutes);
    }

    private static SeekableStreamStartSequenceNumbers<String, String> getStartSequenceNumbers(@Nullable SeekableStreamStartSequenceNumbers<String, String> newStartSequenceNumbers, @Nullable SeekableStreamEndSequenceNumbers<String, String> oldStartSequenceNumbers, @Nullable Set<String> exclusiveStartSequenceNumberPartitions) {
        if (newStartSequenceNumbers == null) {
            Preconditions.checkNotNull(oldStartSequenceNumbers, (Object)"Either startSequenceNumbers or startPartitions shoulnd't be null");
            return new SeekableStreamStartSequenceNumbers(oldStartSequenceNumbers.getStream(), oldStartSequenceNumbers.getPartitionSequenceNumberMap(), exclusiveStartSequenceNumberPartitions);
        }
        return newStartSequenceNumbers;
    }

    @JsonProperty
    @Deprecated
    public SeekableStreamEndSequenceNumbers<String, String> getStartPartitions() {
        SeekableStreamStartSequenceNumbers startSequenceNumbers = this.getStartSequenceNumbers();
        return new SeekableStreamEndSequenceNumbers(startSequenceNumbers.getStream(), startSequenceNumbers.getPartitionSequenceNumberMap());
    }

    @JsonProperty
    @Deprecated
    public SeekableStreamEndSequenceNumbers<String, String> getEndPartitions() {
        return this.getEndSequenceNumbers();
    }

    @JsonProperty
    @Deprecated
    public Set<String> getExclusiveStartSequenceNumberPartitions() {
        return this.getStartSequenceNumbers().getExclusivePartitions();
    }

    @JsonProperty
    public String getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getFetchDelayMillis() {
        return this.fetchDelayMillis;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAwsAssumedRoleArn() {
        return this.awsAssumedRoleArn;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAwsExternalId() {
        return this.awsExternalId;
    }

    public String toString() {
        return "KinesisIndexTaskIOConfig{baseSequenceName='" + this.getBaseSequenceName() + "', startPartitions=" + this.getStartSequenceNumbers() + ", endPartitions=" + this.getEndSequenceNumbers() + ", useTransaction=" + this.isUseTransaction() + ", minimumMessageTime=" + this.getMinimumMessageTime() + ", maximumMessageTime=" + this.getMaximumMessageTime() + ", endpoint='" + this.endpoint + "', fetchDelayMillis=" + this.fetchDelayMillis + ", awsAssumedRoleArn='" + this.awsAssumedRoleArn + "', awsExternalId='" + this.awsExternalId + "'}";
    }
}

