/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client.preauth;

import java.util.ArrayList;
import java.util.List;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.preauth.PreauthHandle;
import org.apache.kerby.kerberos.kerb.client.preauth.UserResponser;
import org.apache.kerby.kerberos.kerb.type.pa.PaData;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;

public class PreauthContext {
    private boolean preauthRequired = true;
    private PaData inputPaData;
    private PaData outputPaData;
    private PaData errorPaData;
    private UserResponser userResponser = new UserResponser();
    private PaDataType allowedPaType;
    private final List<PaDataType> triedPaTypes = new ArrayList<PaDataType>(1);
    private final List<PreauthHandle> handles = new ArrayList<PreauthHandle>(5);

    public PreauthContext() {
        this.allowedPaType = PaDataType.NONE;
        this.outputPaData = new PaData();
    }

    public void reset() {
        this.outputPaData = new PaData();
    }

    public boolean isPreauthRequired() {
        return this.preauthRequired;
    }

    public void setPreauthRequired(boolean preauthRequired) {
        this.preauthRequired = preauthRequired;
    }

    public UserResponser getUserResponser() {
        return this.userResponser;
    }

    public boolean isPaTypeAllowed(PaDataType paType) {
        return this.allowedPaType == PaDataType.NONE || this.allowedPaType == paType;
    }

    public PaData getOutputPaData() throws KrbException {
        return this.outputPaData;
    }

    public boolean hasInputPaData() {
        return this.inputPaData != null && !this.inputPaData.isEmpty();
    }

    public PaData getInputPaData() {
        return this.inputPaData;
    }

    public void setInputPaData(PaData inputPaData) {
        this.inputPaData = inputPaData;
    }

    public PaData getErrorPaData() {
        return this.errorPaData;
    }

    public void setErrorPaData(PaData errorPaData) {
        this.errorPaData = errorPaData;
    }

    public void setAllowedPaType(PaDataType paType) {
        this.allowedPaType = paType;
    }

    public List<PreauthHandle> getHandles() {
        return this.handles;
    }

    public PaDataType getAllowedPaType() {
        return this.allowedPaType;
    }

    public boolean checkAndPutTried(PaDataType paType) {
        for (PaDataType pt : this.triedPaTypes) {
            if (pt != paType) continue;
            return true;
        }
        this.triedPaTypes.add(paType);
        return false;
    }
}

