/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window;

import java.time.ZoneId;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.buffers.AsyncStateRecordsWindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.buffers.AsyncStateWindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.combines.AsyncStateAggCombiner;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.processors.AsyncStateSliceSharedWindowAggProcessor;
import org.apache.flink.table.runtime.operators.aggregate.asyncwindow.processors.AsyncStateSliceUnsharedWindowAggProcessor;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.RecordsWindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.WindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.combines.AggCombiner;
import org.apache.flink.table.runtime.operators.aggregate.window.combines.GlobalAggCombiner;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.AbstractSliceSyncStateWindowAggProcessor;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.SliceSharedSyncStateWindowAggProcessor;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.SliceUnsharedSyncStateWindowAggProcessor;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.UnsliceSyncStateWindowAggProcessor;
import org.apache.flink.table.runtime.operators.window.async.tvf.common.AsyncStateWindowAggOperator;
import org.apache.flink.table.runtime.operators.window.async.tvf.slicing.AsyncStateSlicingWindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.combines.RecordsCombiner;
import org.apache.flink.table.runtime.operators.window.tvf.common.SyncStateWindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAggOperator;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceSharedAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceUnsharedAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SlicingSyncStateWindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.unslicing.UnsliceAssigner;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.util.Preconditions;

public class WindowAggOperatorBuilder {
    private WindowAssigner assigner;
    private AbstractRowDataSerializer<RowData> inputSerializer;
    private PagedTypeSerializer<RowData> keySerializer;
    private AbstractRowDataSerializer<RowData> accSerializer;
    private GeneratedNamespaceAggsHandleFunction<?> generatedAggregateFunction;
    private GeneratedNamespaceAggsHandleFunction<?> localGeneratedAggregateFunction;
    private GeneratedNamespaceAggsHandleFunction<?> globalGeneratedAggregateFunction;
    private GeneratedRecordEqualiser generatedKeyEqualiser;
    private int indexOfCountStart = -1;
    private ZoneId shiftTimeZone;
    private boolean enableAsyncState;

    public static WindowAggOperatorBuilder builder() {
        return new WindowAggOperatorBuilder();
    }

    public WindowAggOperatorBuilder inputSerializer(AbstractRowDataSerializer<RowData> inputSerializer) {
        this.inputSerializer = inputSerializer;
        return this;
    }

    public WindowAggOperatorBuilder shiftTimeZone(ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        return this;
    }

    public WindowAggOperatorBuilder keySerializer(PagedTypeSerializer<RowData> keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    public WindowAggOperatorBuilder generatedKeyEqualiser(GeneratedRecordEqualiser generatedKeyEqualiser) {
        this.generatedKeyEqualiser = generatedKeyEqualiser;
        return this;
    }

    public WindowAggOperatorBuilder assigner(WindowAssigner assigner) {
        this.assigner = assigner;
        return this;
    }

    public WindowAggOperatorBuilder aggregate(GeneratedNamespaceAggsHandleFunction<?> generatedAggregateFunction, AbstractRowDataSerializer<RowData> accSerializer) {
        this.generatedAggregateFunction = generatedAggregateFunction;
        this.accSerializer = accSerializer;
        return this;
    }

    public WindowAggOperatorBuilder globalAggregate(GeneratedNamespaceAggsHandleFunction<?> localGeneratedAggregateFunction, GeneratedNamespaceAggsHandleFunction<?> globalGeneratedAggregateFunction, GeneratedNamespaceAggsHandleFunction<?> stateGeneratedAggregateFunction, AbstractRowDataSerializer<RowData> accSerializer) {
        this.localGeneratedAggregateFunction = localGeneratedAggregateFunction;
        this.globalGeneratedAggregateFunction = globalGeneratedAggregateFunction;
        this.generatedAggregateFunction = stateGeneratedAggregateFunction;
        this.accSerializer = accSerializer;
        return this;
    }

    public WindowAggOperatorBuilder countStarIndex(int indexOfCountStart) {
        this.indexOfCountStart = indexOfCountStart;
        return this;
    }

    public WindowAggOperatorBuilder enableAsyncState() {
        this.enableAsyncState = true;
        return this;
    }

    public OneInputStreamOperator<RowData, RowData> build() {
        Preconditions.checkNotNull((Object)this.assigner);
        Preconditions.checkNotNull(this.inputSerializer);
        Preconditions.checkNotNull(this.keySerializer);
        Preconditions.checkNotNull(this.accSerializer);
        Preconditions.checkNotNull(this.generatedAggregateFunction);
        if (this.enableAsyncState) {
            return this.buildAsyncStateOperator();
        }
        return this.buildSyncStateOperator();
    }

    private WindowAggOperator<RowData, ?> buildSyncStateOperator() {
        SyncStateWindowProcessor<Long> windowProcessor = this.assigner instanceof SliceAssigner ? this.buildSlicingWindowProcessor() : this.buildUnslicingWindowProcessor();
        return new WindowAggOperator(windowProcessor, this.assigner.isEventTime());
    }

    private AsyncStateWindowAggOperator<RowData, ?> buildAsyncStateOperator() {
        Preconditions.checkState((!this.isGlobalAgg() ? 1 : 0) != 0, (Object)"Currently only one-stage window agg supports async state.");
        Preconditions.checkState((boolean)(this.assigner instanceof SliceAssigner), (Object)"Currently only slice window supports async state.");
        Preconditions.checkNotNull((Object)this.generatedKeyEqualiser);
        AsyncStateSlicingWindowProcessor<Long> windowProcessor = this.buildAsyncStateSlicingWindowProcessor();
        return new AsyncStateWindowAggOperator(windowProcessor, this.assigner.isEventTime());
    }

    private SlicingSyncStateWindowProcessor<Long> buildSlicingWindowProcessor() {
        AbstractSliceSyncStateWindowAggProcessor windowProcessor;
        RecordsCombiner.Factory combinerFactory = this.isGlobalAgg() ? new GlobalAggCombiner.Factory(this.localGeneratedAggregateFunction, this.globalGeneratedAggregateFunction) : new AggCombiner.Factory(this.generatedAggregateFunction);
        RecordsWindowBuffer.Factory bufferFactory = new RecordsWindowBuffer.Factory(this.keySerializer, this.inputSerializer, combinerFactory);
        if (this.assigner instanceof SliceSharedAssigner) {
            windowProcessor = new SliceSharedSyncStateWindowAggProcessor(this.generatedAggregateFunction, (WindowBuffer.Factory)bufferFactory, (SliceSharedAssigner)this.assigner, this.accSerializer, this.indexOfCountStart, this.shiftTimeZone);
        } else if (this.assigner instanceof SliceUnsharedAssigner) {
            windowProcessor = new SliceUnsharedSyncStateWindowAggProcessor(this.generatedAggregateFunction, (WindowBuffer.Factory)bufferFactory, (SliceUnsharedAssigner)this.assigner, this.accSerializer, this.indexOfCountStart, this.shiftTimeZone);
        } else {
            throw new IllegalArgumentException("assigner must be instance of SliceUnsharedAssigner or SliceSharedAssigner.");
        }
        return windowProcessor;
    }

    private UnsliceSyncStateWindowAggProcessor buildUnslicingWindowProcessor() {
        return new UnsliceSyncStateWindowAggProcessor(this.generatedAggregateFunction, (UnsliceAssigner)this.assigner, this.accSerializer, this.indexOfCountStart, this.shiftTimeZone);
    }

    private AsyncStateSlicingWindowProcessor<Long> buildAsyncStateSlicingWindowProcessor() {
        AsyncStateAggCombiner.Factory combinerFactory = new AsyncStateAggCombiner.Factory(this.generatedAggregateFunction);
        AsyncStateRecordsWindowBuffer.Factory bufferFactory = new AsyncStateRecordsWindowBuffer.Factory(this.keySerializer, this.inputSerializer, combinerFactory, this.generatedKeyEqualiser);
        if (this.assigner instanceof SliceSharedAssigner) {
            return new AsyncStateSliceSharedWindowAggProcessor(this.generatedAggregateFunction, (AsyncStateWindowBuffer.Factory)bufferFactory, (SliceSharedAssigner)this.assigner, this.accSerializer, this.indexOfCountStart, this.shiftTimeZone);
        }
        if (this.assigner instanceof SliceUnsharedAssigner) {
            return new AsyncStateSliceUnsharedWindowAggProcessor(this.generatedAggregateFunction, (AsyncStateWindowBuffer.Factory)bufferFactory, (SliceUnsharedAssigner)this.assigner, this.accSerializer, this.indexOfCountStart, this.shiftTimeZone);
        }
        throw new IllegalArgumentException("assigner must be instance of SliceUnsharedAssigner or SliceSharedAssigner.");
    }

    private boolean isGlobalAgg() {
        return this.localGeneratedAggregateFunction != null && this.globalGeneratedAggregateFunction != null;
    }
}

