/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.CompiledPlan;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.ExplainFormat;
import org.apache.flink.table.api.FunctionDescriptor;
import org.apache.flink.table.api.Model;
import org.apache.flink.table.api.ModelDescriptor;
import org.apache.flink.table.api.PlanReference;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleEntry;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.table.types.AbstractDataType;

@PublicEvolving
public interface TableEnvironment {
    public static TableEnvironment create(EnvironmentSettings settings) {
        return TableEnvironmentImpl.create(settings);
    }

    public static TableEnvironment create(Configuration configuration) {
        return TableEnvironmentImpl.create(configuration);
    }

    default public Table fromValues(Object ... values) {
        return this.fromValues(Arrays.asList(values));
    }

    default public Table fromValues(AbstractDataType<?> rowType, Object ... values) {
        return this.fromValues(rowType, Arrays.asList(values));
    }

    public Table fromValues(Expression ... var1);

    public Table fromValues(AbstractDataType<?> var1, Expression ... var2);

    public Table fromValues(Iterable<?> var1);

    public Table fromValues(AbstractDataType<?> var1, Iterable<?> var2);

    @Deprecated
    public void registerCatalog(String var1, Catalog var2);

    public void createCatalog(String var1, CatalogDescriptor var2);

    public Optional<Catalog> getCatalog(String var1);

    public void loadModule(String var1, Module var2);

    public void useModules(String ... var1);

    public void unloadModule(String var1);

    @Deprecated
    public void registerFunction(String var1, ScalarFunction var2);

    public void createTemporarySystemFunction(String var1, Class<? extends UserDefinedFunction> var2);

    public void createTemporarySystemFunction(String var1, UserDefinedFunction var2);

    public boolean dropTemporarySystemFunction(String var1);

    public void createFunction(String var1, Class<? extends UserDefinedFunction> var2);

    public void createFunction(String var1, Class<? extends UserDefinedFunction> var2, boolean var3);

    public void createFunction(String var1, String var2, List<ResourceUri> var3);

    public void createFunction(String var1, FunctionDescriptor var2);

    public void createFunction(String var1, String var2, List<ResourceUri> var3, boolean var4);

    public void createFunction(String var1, FunctionDescriptor var2, boolean var3);

    public void createTemporaryFunction(String var1, Class<? extends UserDefinedFunction> var2);

    public void createTemporaryFunction(String var1, UserDefinedFunction var2);

    public void createTemporaryFunction(String var1, String var2, List<ResourceUri> var3);

    public void createTemporaryFunction(String var1, FunctionDescriptor var2);

    public void createTemporarySystemFunction(String var1, String var2, List<ResourceUri> var3);

    public void createTemporarySystemFunction(String var1, FunctionDescriptor var2);

    public boolean dropFunction(String var1);

    public boolean dropTemporaryFunction(String var1);

    public void createTemporaryTable(String var1, TableDescriptor var2);

    public void createTemporaryTable(String var1, TableDescriptor var2, boolean var3);

    public void createTable(String var1, TableDescriptor var2);

    public boolean createTable(String var1, TableDescriptor var2, boolean var3);

    @Deprecated
    public void registerTable(String var1, Table var2);

    public void createTemporaryView(String var1, Table var2);

    public void createView(String var1, Table var2);

    public boolean createView(String var1, Table var2, boolean var3);

    public void createModel(String var1, ModelDescriptor var2);

    public void createModel(String var1, ModelDescriptor var2, boolean var3);

    public void createTemporaryModel(String var1, ModelDescriptor var2);

    public void createTemporaryModel(String var1, ModelDescriptor var2, boolean var3);

    @Deprecated
    public Table scan(String ... var1);

    public Table from(String var1);

    public Table from(TableDescriptor var1);

    public Table fromCall(String var1, Object ... var2);

    public Table fromCall(Class<? extends UserDefinedFunction> var1, Object ... var2);

    public Model fromModel(String var1);

    public Model fromModel(ModelDescriptor var1);

    public String[] listCatalogs();

    public String[] listModules();

    public ModuleEntry[] listFullModules();

    public String[] listDatabases();

    public String[] listTables();

    public String[] listTables(String var1, String var2);

    public String[] listViews();

    public String[] listMaterializedTables();

    public String[] listTemporaryTables();

    public String[] listTemporaryViews();

    public String[] listUserDefinedFunctions();

    public String[] listFunctions();

    public String[] listModels();

    public String[] listTemporaryModels();

    public boolean dropTemporaryTable(String var1);

    public boolean dropTable(String var1);

    public boolean dropTable(String var1, boolean var2);

    public boolean dropTemporaryView(String var1);

    public boolean dropView(String var1);

    public boolean dropView(String var1, boolean var2);

    public boolean dropModel(String var1);

    public boolean dropModel(String var1, boolean var2);

    public boolean dropTemporaryModel(String var1);

    default public String explainSql(String statement, ExplainDetail ... extraDetails) {
        return this.explainSql(statement, ExplainFormat.TEXT, extraDetails);
    }

    public String explainSql(String var1, ExplainFormat var2, ExplainDetail ... var3);

    @Deprecated
    public String[] getCompletionHints(String var1, int var2);

    public Table sqlQuery(String var1);

    public TableResult executeSql(String var1);

    public String getCurrentCatalog();

    public void useCatalog(@Nullable String var1);

    public String getCurrentDatabase();

    public void useDatabase(@Nullable String var1);

    public TableConfig getConfig();

    public StatementSet createStatementSet();

    @Experimental
    public CompiledPlan loadPlan(PlanReference var1) throws TableException;

    @Experimental
    public CompiledPlan compilePlanSql(String var1) throws TableException;

    @Experimental
    default public TableResult executePlan(PlanReference planReference) throws TableException {
        return this.loadPlan(planReference).execute();
    }
}

