/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.internal.CommandProcessor;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.CommandProcessingException;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.geode.management.internal.cli.CommandManager;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.remote.CommandExecutor;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.util.CommentSkipHelper;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.springframework.shell.core.Parser;
import org.springframework.shell.event.ParseResult;

public class OnlineCommandProcessor
implements CommandProcessor {
    protected CommandExecutor executor;
    private GfshParser gfshParser;
    private final Object LOCK = new Object();
    private SecurityService securityService;

    public OnlineCommandProcessor() {
    }

    @VisibleForTesting
    public OnlineCommandProcessor(GfshParser gfshParser, SecurityService securityService, CommandExecutor commandExecutor) {
        this.gfshParser = gfshParser;
        this.executor = commandExecutor;
        this.securityService = securityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommandExecutor getCommandExecutor() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Parser getParser() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.gfshParser;
        }
    }

    public ParseResult parseCommand(String commentLessLine) throws CommandProcessingException, IllegalStateException {
        if (commentLessLine != null) {
            return this.getParser().parse(commentLessLine);
        }
        throw new IllegalStateException("Command String should not be null.");
    }

    public ResultModel executeCommand(String command) {
        return this.executeCommand(command, Collections.emptyMap(), null);
    }

    public ResultModel executeCommand(String command, Map<String, String> env, List<String> stagedFilePaths) {
        CliMetaData metaData;
        CommentSkipHelper commentSkipper = new CommentSkipHelper();
        String commentLessLine = commentSkipper.skipComments(command);
        if (commentLessLine == null || commentLessLine.isEmpty()) {
            return null;
        }
        CommandExecutionContext.setShellEnv(env);
        CommandExecutionContext.setFilePathToShell(stagedFilePaths);
        CommandExecutor commandExecutor = this.getCommandExecutor();
        ParseResult parseResult = this.parseCommand(commentLessLine);
        if (parseResult == null) {
            String version = GemFireVersion.getGemFireVersion();
            String message = "Could not parse command string. " + command + "." + System.lineSeparator() + "The command or some options in this command may not be supported by this locator(" + version + ") gfsh is connected with.";
            return ResultModel.createError(message);
        }
        Method method = parseResult.getMethod();
        ResourceOperation resourceOperation = method.getAnnotation(ResourceOperation.class);
        if (resourceOperation != null) {
            this.securityService.authorize(resourceOperation.resource(), resourceOperation.operation(), resourceOperation.target(), "*");
        }
        if ((metaData = method.getAnnotation(CliMetaData.class)) != null && metaData.isFileUploaded() && stagedFilePaths == null) {
            return ResultModel.createError(command + " can not be executed only from server side");
        }
        return (ResultModel)commandExecutor.execute((GfshParseResult)parseResult);
    }

    public String executeCommandReturningJson(String command, Map<String, String> env, List<String> stagedFilePaths) {
        return this.executeCommand(command, env, stagedFilePaths).toJson();
    }

    public boolean init(Cache cache) {
        Properties cacheProperties = cache.getDistributedSystem().getProperties();
        this.securityService = ((InternalCache)cache).getSecurityService();
        this.gfshParser = new GfshParser(new CommandManager(cacheProperties, (InternalCache)cache));
        DistributedLockService cmsDlockService = DLockService.getOrCreateService((String)"CMS_DLOCK_SERVICE", (InternalDistributedSystem)((InternalCache)cache).getInternalDistributedSystem());
        this.executor = new CommandExecutor(cmsDlockService);
        return true;
    }

    public Class<? extends CacheService> getInterface() {
        return CommandProcessor.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }
}

