/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.ServerLocator;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.GridAdvisor;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class ControllerAdvisor
extends GridAdvisor {
    private ControllerAdvisor(DistributionAdvisee server) {
        super(server);
    }

    public static ControllerAdvisor createControllerAdvisor(DistributionAdvisee server) {
        ControllerAdvisor advisor = new ControllerAdvisor(server);
        advisor.initialize();
        return advisor;
    }

    @Override
    protected void profileCreated(DistributionAdvisor.Profile profile) {
        super.profileCreated(profile);
        ((ServerLocator)this.getAdvisee()).profileCreated(profile);
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        super.profileRemoved(profile);
        ((ServerLocator)this.getAdvisee()).profileRemoved(profile);
    }

    @Override
    protected void profileUpdated(DistributionAdvisor.Profile profile) {
        super.profileUpdated(profile);
        ((ServerLocator)this.getAdvisee()).profileUpdated(profile);
    }

    @Override
    protected void profilesChanged() {
        if (this.pollIsInitialized()) {
            super.profilesChanged();
            ServerLocator sl = (ServerLocator)this.getAdvisee();
            sl.setLocatorCount(this.getControllerCount());
            sl.setServerCount(this.getBridgeServerCount());
        }
    }

    public String toString() {
        return "ControllerAdvisor for " + this.getAdvisee().getFullPath();
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new ControllerProfile(memberId, version);
    }

    public static class ControllerProfile
    extends GridAdvisor.GridProfile {
        public ControllerProfile() {
        }

        public ControllerProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public ControllerProfile(ControllerProfile toCopy) {
            super(toCopy);
        }

        @Override
        public void processIncoming(ClusterDistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            this.tellLocalControllers(removeProfile, exchangeProfiles, replyProfiles);
            this.tellLocalBridgeServers(dm.getCache(), removeProfile, exchangeProfiles, replyProfiles);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
        }

        @Override
        public int getDSFID() {
            return -90;
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("ControllerProfile");
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
        }
    }
}

