/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Evolving
public class RuleBasedLdapGroupsMapping
extends LdapGroupsMapping {
    public static final String CONVERSION_RULE_KEY = "hadoop.security.group.mapping.ldap.conversion.rule";
    private static final String CONVERSION_RULE_DEFAULT = "none";
    private static final Logger LOG = LoggerFactory.getLogger(RuleBasedLdapGroupsMapping.class);
    private Rule rule;

    @Override
    public synchronized void setConf(Configuration conf) {
        super.setConf(conf);
        String value = conf.get(CONVERSION_RULE_KEY, CONVERSION_RULE_DEFAULT);
        try {
            this.rule = Rule.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Invalid {} configured: '{}'. Using default value: '{}'", new Object[]{CONVERSION_RULE_KEY, value, CONVERSION_RULE_DEFAULT});
        }
    }

    @Override
    public synchronized List<String> getGroups(String user) {
        List<String> groups = super.getGroups(user);
        ArrayList<String> result = new ArrayList<String>(groups.size());
        switch (this.rule) {
            case TO_UPPER: {
                for (String group : groups) {
                    result.add(StringUtils.toUpperCase(group));
                }
                return result;
            }
            case TO_LOWER: {
                for (String group : groups) {
                    result.add(StringUtils.toLowerCase(group));
                }
                return result;
            }
        }
        return groups;
    }

    private static enum Rule {
        TO_UPPER,
        TO_LOWER,
        NONE;

    }
}

