/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.metrics.CounterResult;
import org.apache.iceberg.metrics.MetricsContext;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CounterResult", generator="Immutables")
@Immutable
public final class ImmutableCounterResult
implements CounterResult {
    private final MetricsContext.Unit unit;
    private final long value;

    private ImmutableCounterResult(MetricsContext.Unit unit, long value) {
        this.unit = unit;
        this.value = value;
    }

    @Override
    public MetricsContext.Unit unit() {
        return this.unit;
    }

    @Override
    public long value() {
        return this.value;
    }

    public final ImmutableCounterResult withUnit(MetricsContext.Unit value) {
        MetricsContext.Unit newValue = Objects.requireNonNull(value, "unit");
        if (this.unit == newValue) {
            return this;
        }
        return new ImmutableCounterResult(newValue, this.value);
    }

    public final ImmutableCounterResult withValue(long value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableCounterResult(this.unit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCounterResult && this.equalTo(0, (ImmutableCounterResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableCounterResult another) {
        return this.unit.equals((Object)another.unit) && this.value == another.value;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.unit.hashCode();
        h += (h << 5) + Long.hashCode(this.value);
        return h;
    }

    public String toString() {
        return "CounterResult{unit=" + String.valueOf(this.unit) + ", value=" + this.value + "}";
    }

    public static ImmutableCounterResult copyOf(CounterResult instance) {
        if (instance instanceof ImmutableCounterResult) {
            return (ImmutableCounterResult)instance;
        }
        return ImmutableCounterResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CounterResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_UNIT = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private MetricsContext.Unit unit;
        private long value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CounterResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.unit(instance.unit());
            this.value(instance.value());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder unit(MetricsContext.Unit unit) {
            this.unit = Objects.requireNonNull(unit, "unit");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(long value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCounterResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCounterResult(this.unit, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("unit");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build CounterResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

