/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.stats;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.stats.PartitionStatisticsUpdate;
import org.apache.gravitino.stats.StatisticValue;

public class PartitionStatisticsUpdateDTO
implements PartitionStatisticsUpdate {
    @JsonProperty(value="partitionName")
    private final String partitionName;
    @JsonProperty(value="statistics")
    @JsonSerialize(contentUsing=JsonUtils.StatisticValueSerializer.class)
    @JsonDeserialize(contentUsing=JsonUtils.StatisticValueDeserializer.class)
    private final Map<String, StatisticValue<?>> statistics;

    protected PartitionStatisticsUpdateDTO() {
        this(null, null);
    }

    private PartitionStatisticsUpdateDTO(String partitionName, Map<String, StatisticValue<?>> statistics) {
        this.partitionName = partitionName;
        this.statistics = statistics;
    }

    @Override
    public String partitionName() {
        return this.partitionName;
    }

    @Override
    public Map<String, StatisticValue<?>> statistics() {
        return this.statistics;
    }

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(this.partitionName), "\"partitionName\" must not be null or empty");
        Preconditions.checkArgument(this.statistics != null && !this.statistics.isEmpty(), "\"statistics\" must not be null or empty");
    }

    public static PartitionStatisticsUpdateDTO of(String partitionName, Map<String, StatisticValue<?>> statistics) {
        PartitionStatisticsUpdateDTO dto = new PartitionStatisticsUpdateDTO(partitionName, statistics);
        dto.validate();
        return dto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionStatisticsUpdateDTO)) {
            return false;
        }
        PartitionStatisticsUpdateDTO other = (PartitionStatisticsUpdateDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$partitionName = this.partitionName;
        String other$partitionName = other.partitionName;
        if (this$partitionName == null ? other$partitionName != null : !this$partitionName.equals(other$partitionName)) {
            return false;
        }
        Map<String, StatisticValue<?>> this$statistics = this.statistics;
        Map<String, StatisticValue<?>> other$statistics = other.statistics;
        return !(this$statistics == null ? other$statistics != null : !((Object)this$statistics).equals(other$statistics));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionStatisticsUpdateDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $partitionName = this.partitionName;
        result = result * 59 + ($partitionName == null ? 43 : $partitionName.hashCode());
        Map<String, StatisticValue<?>> $statistics = this.statistics;
        result = result * 59 + ($statistics == null ? 43 : ((Object)$statistics).hashCode());
        return result;
    }

    public String toString() {
        return "PartitionStatisticsUpdateDTO(partitionName=" + this.partitionName + ", statistics=" + String.valueOf(this.statistics) + ")";
    }
}

