/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.file;

import com.lancedb.lance.JniLoader;
import com.lancedb.lance.util.Range;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.types.pojo.Schema;

public class LanceFileReader
implements AutoCloseable {
    private long nativeFileReaderHandle;
    private BufferAllocator allocator;
    private Schema schema;

    private static native LanceFileReader openNative(String var0, Map<String, String> var1) throws IOException;

    private native void closeNative(long var1) throws IOException;

    private native long numRowsNative() throws IOException;

    private native void populateSchemaNative(long var1);

    private native void readAllNative(int var1, @Nullable List<String> var2, @Nullable List<Range> var3, long var4) throws IOException;

    private LanceFileReader() {
    }

    public static LanceFileReader open(String path, BufferAllocator allocator) throws IOException {
        return LanceFileReader.open(path, Collections.emptyMap(), allocator);
    }

    public static LanceFileReader open(String path, Map<String, String> storageOptions, BufferAllocator allocator) throws IOException {
        LanceFileReader reader = LanceFileReader.openNative(path, storageOptions);
        reader.allocator = allocator;
        reader.schema = reader.load_schema();
        return reader;
    }

    @Override
    public void close() throws Exception {
        this.closeNative(this.nativeFileReaderHandle);
    }

    public long numRows() throws IOException {
        long numRows = this.numRowsNative();
        return numRows;
    }

    public Schema schema() {
        return this.schema;
    }

    private Schema load_schema() throws IOException {
        try (ArrowSchema ffiArrowSchema = ArrowSchema.allocateNew((BufferAllocator)this.allocator);){
            this.populateSchemaNative(ffiArrowSchema.memoryAddress());
            Schema schema = Data.importSchema((BufferAllocator)this.allocator, (ArrowSchema)ffiArrowSchema, null);
            return schema;
        }
    }

    public ArrowReader readAll(@Nullable List<String> projectedNames, @Nullable List<Range> ranges, int batchSize) throws IOException {
        try (ArrowArrayStream ffiArrowArrayStream = ArrowArrayStream.allocateNew((BufferAllocator)this.allocator);){
            this.readAllNative(batchSize, projectedNames, ranges, ffiArrowArrayStream.memoryAddress());
            ArrowReader arrowReader = Data.importArrayStream((BufferAllocator)this.allocator, (ArrowArrayStream)ffiArrowArrayStream);
            return arrowReader;
        }
    }

    static {
        JniLoader.ensureLoaded();
    }
}

