/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lineage.source.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import io.openlineage.server.OpenLineage;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.lineage.LineageDispatcher;
import org.apache.gravitino.lineage.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/lineage")
public class LineageOperations {
    private static final Logger LOG = LoggerFactory.getLogger(LineageOperations.class);
    private LineageDispatcher lineageDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public LineageOperations(LineageDispatcher lineageDispatcher) {
        this.lineageDispatcher = lineageDispatcher;
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="post-lineage.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="post-lineage", absolute=true)
    public Response postLineage(OpenLineage.RunEvent event) {
        LOG.info("Open lineage event, run id:{}, job name:{}", (Object)Utils.getRunID(event), (Object)Utils.getJobName(event));
        try {
            return org.apache.gravitino.server.web.Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                if (this.lineageDispatcher.dispatchLineageEvent(event)) {
                    return org.apache.gravitino.server.web.Utils.created();
                }
                return org.apache.gravitino.server.web.Utils.tooManyRequests();
            });
        }
        catch (Exception e) {
            LOG.warn("Process lineage failed,", (Throwable)e);
            return org.apache.gravitino.server.web.Utils.internalError((String)e.getMessage(), (Throwable)e);
        }
    }
}

