/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openlineage.client.MergeConfig;
import io.openlineage.client.transports.TransportConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class CompositeConfig
implements TransportConfig,
MergeConfig<CompositeConfig> {
    private List<TransportConfig> transports;
    private Boolean continueOnFailure;
    private Boolean withThreadPool;

    @JsonCreator
    public CompositeConfig(@JsonProperty(value="transports") Object transports, @JsonProperty(value="continueOnFailure") Boolean continueOnFailure, @JsonProperty(value="withThreadPool") Boolean withThreadPool) {
        if (transports instanceof List) {
            this.transports = ((List)transports).stream().map(this::createTransportConfig).sorted(TransportConfig::compareTo).collect(Collectors.toList());
        } else if (transports instanceof Map) {
            Map transportMap = (Map)transports;
            this.transports = transportMap.entrySet().stream().map(entry -> {
                HashMap nestedMap = new HashMap();
                nestedMap.putAll((Map)entry.getValue());
                nestedMap.put("name", entry.getKey());
                return nestedMap;
            }).map(this::createTransportConfig).sorted(TransportConfig::compareTo).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("Invalid transports type");
        }
        this.continueOnFailure = continueOnFailure == null ? true : continueOnFailure;
        this.withThreadPool = withThreadPool == null ? true : withThreadPool;
    }

    public static CompositeConfig createFromTransportConfigs(List<TransportConfig> transports, boolean continueOnFailure, boolean withThreadPool) {
        CompositeConfig compositeConfig = new CompositeConfig();
        compositeConfig.setTransports(transports);
        compositeConfig.setContinueOnFailure(continueOnFailure);
        compositeConfig.setWithThreadPool(withThreadPool);
        return compositeConfig;
    }

    private TransportConfig createTransportConfig(Map<String, Object> map) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String jsonString = objectMapper.writeValueAsString(map);
            return (TransportConfig)objectMapper.readValue(jsonString, TransportConfig.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error creating transport config", e);
        }
    }

    @Override
    public CompositeConfig mergeWithNonNull(CompositeConfig other) {
        List<TransportConfig> mergedTransports = this.mergePropertyWith(this.transports, other.getTransports());
        Boolean mergedContinueOnFailure = this.mergePropertyWith(this.continueOnFailure, other.continueOnFailure);
        Boolean mergedWithThreadPool = this.mergePropertyWith(this.withThreadPool, other.withThreadPool);
        return CompositeConfig.createFromTransportConfigs(mergedTransports, mergedContinueOnFailure, mergedWithThreadPool);
    }

    @Generated
    public String toString() {
        return "CompositeConfig(transports=" + this.getTransports() + ", continueOnFailure=" + this.getContinueOnFailure() + ", withThreadPool=" + this.getWithThreadPool() + ")";
    }

    @Generated
    public CompositeConfig() {
    }

    @Generated
    public List<TransportConfig> getTransports() {
        return this.transports;
    }

    @Generated
    public void setTransports(List<TransportConfig> transports) {
        this.transports = transports;
    }

    @Generated
    public Boolean getContinueOnFailure() {
        return this.continueOnFailure;
    }

    @Generated
    public void setContinueOnFailure(Boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    @Generated
    public Boolean getWithThreadPool() {
        return this.withThreadPool;
    }

    @Generated
    public void setWithThreadPool(Boolean withThreadPool) {
        this.withThreadPool = withThreadPool;
    }
}

