/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.privilege;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.privilege.PrivilegeChecker;
import org.apache.paimon.privilege.PrivilegedFileStore;
import org.apache.paimon.privilege.PrivilegedObjectTable;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.DelegatedFileStoreTable;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.object.ObjectTable;
import org.apache.paimon.table.query.LocalTableQuery;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.table.sink.WriteSelector;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class PrivilegedFileStoreTable
extends DelegatedFileStoreTable {
    protected final PrivilegeChecker privilegeChecker;
    protected final Identifier identifier;

    protected PrivilegedFileStoreTable(FileStoreTable wrapped, PrivilegeChecker privilegeChecker, Identifier identifier) {
        super(wrapped);
        this.privilegeChecker = privilegeChecker;
        this.identifier = identifier;
    }

    @Override
    public SnapshotManager snapshotManager() {
        this.privilegeChecker.assertCanSelectOrInsert(this.identifier);
        return this.wrapped.snapshotManager();
    }

    @Override
    public ChangelogManager changelogManager() {
        this.privilegeChecker.assertCanSelectOrInsert(this.identifier);
        return this.wrapped.changelogManager();
    }

    @Override
    public Optional<Snapshot> latestSnapshot() {
        this.privilegeChecker.assertCanSelectOrInsert(this.identifier);
        return this.wrapped.latestSnapshot();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        this.privilegeChecker.assertCanSelectOrInsert(this.identifier);
        return this.wrapped.snapshot(snapshotId);
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newSnapshotReader();
    }

    @Override
    public TagManager tagManager() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.tagManager();
    }

    @Override
    public BranchManager branchManager() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.branchManager();
    }

    @Override
    public FileStore<?> store() {
        return new PrivilegedFileStore(this.wrapped.store(), this.privilegeChecker, this.identifier);
    }

    @Override
    public Optional<Statistics> statistics() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.statistics();
    }

    @Override
    public void rollbackTo(long snapshotId) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.rollbackTo(snapshotId);
    }

    @Override
    public void createTag(String tagName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createTag(tagName);
    }

    @Override
    public void createTag(String tagName, long fromSnapshotId) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createTag(tagName, fromSnapshotId);
    }

    @Override
    public void createTag(String tagName, Duration timeRetained) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createTag(tagName, timeRetained);
    }

    @Override
    public void renameTag(String tagName, String targetTagName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.renameTag(tagName, targetTagName);
    }

    @Override
    public void createTag(String tagName, long fromSnapshotId, Duration timeRetained) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createTag(tagName, fromSnapshotId, timeRetained);
    }

    @Override
    public void deleteTag(String tagName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.deleteTag(tagName);
    }

    @Override
    public void rollbackTo(String tagName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.rollbackTo(tagName);
    }

    @Override
    public void createBranch(String branchName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createBranch(branchName);
    }

    @Override
    public void createBranch(String branchName, String tagName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.createBranch(branchName, tagName);
    }

    @Override
    public void deleteBranch(String branchName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.deleteBranch(branchName);
    }

    @Override
    public void fastForward(String branchName) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        this.wrapped.fastForward(branchName);
    }

    @Override
    public ExpireSnapshots newExpireSnapshots() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newExpireSnapshots();
    }

    @Override
    public ExpireSnapshots newExpireChangelog() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newExpireChangelog();
    }

    @Override
    public DataTableScan newScan() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newScan();
    }

    @Override
    public StreamDataTableScan newStreamScan() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newStreamScan();
    }

    @Override
    public InnerTableRead newRead() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newRead();
    }

    @Override
    public Optional<WriteSelector> newWriteSelector() {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newWriteSelector();
    }

    @Override
    public TableWriteImpl<?> newWrite(String commitUser) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newWrite(commitUser);
    }

    @Override
    public TableWriteImpl<?> newWrite(String commitUser, @Nullable ManifestCacheFilter manifestFilter, @Nullable Integer writeId) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newWrite(commitUser, manifestFilter, writeId);
    }

    @Override
    public TableCommitImpl newCommit(String commitUser) {
        this.privilegeChecker.assertCanInsert(this.identifier);
        return this.wrapped.newCommit(commitUser);
    }

    @Override
    public LocalTableQuery newLocalTableQuery() {
        this.privilegeChecker.assertCanSelect(this.identifier);
        return this.wrapped.newLocalTableQuery();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegedFileStoreTable that = (PrivilegedFileStoreTable)o;
        return Objects.equals(this.wrapped, that.wrapped) && Objects.equals(this.privilegeChecker, that.privilegeChecker) && Objects.equals(this.identifier, that.identifier);
    }

    @Override
    public PrivilegedFileStoreTable copy(Map<String, String> dynamicOptions) {
        return new PrivilegedFileStoreTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions), this.privilegeChecker, this.identifier);
    }

    @Override
    public PrivilegedFileStoreTable copy(TableSchema newTableSchema) {
        return new PrivilegedFileStoreTable(this.wrapped.copy(newTableSchema), this.privilegeChecker, this.identifier);
    }

    @Override
    public PrivilegedFileStoreTable copyWithoutTimeTravel(Map<String, String> dynamicOptions) {
        return new PrivilegedFileStoreTable(this.wrapped.copyWithoutTimeTravel(dynamicOptions), this.privilegeChecker, this.identifier);
    }

    @Override
    public PrivilegedFileStoreTable copyWithLatestSchema() {
        return new PrivilegedFileStoreTable(this.wrapped.copyWithLatestSchema(), this.privilegeChecker, this.identifier);
    }

    @Override
    public PrivilegedFileStoreTable switchToBranch(String branchName) {
        return new PrivilegedFileStoreTable(this.wrapped.switchToBranch(branchName), this.privilegeChecker, this.identifier);
    }

    public static PrivilegedFileStoreTable wrap(FileStoreTable table, PrivilegeChecker privilegeChecker, Identifier identifier) {
        if (table instanceof ObjectTable) {
            return new PrivilegedObjectTable((ObjectTable)table, privilegeChecker, identifier);
        }
        return new PrivilegedFileStoreTable(table, privilegeChecker, identifier);
    }
}

