/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.CatalogDispatcher;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.CatalogInUseException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;

public class CatalogNormalizeDispatcher
implements CatalogDispatcher {
    private static final Set<String> RESERVED_WORDS = ImmutableSet.of((Object)"*", (Object)"system");
    private static final String CATALOG_NAME_PATTERN = "^\\w[\\w-]{0,63}$";
    private final CatalogDispatcher dispatcher;

    public CatalogNormalizeDispatcher(CatalogDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public NameIdentifier[] listCatalogs(Namespace namespace) throws NoSuchMetalakeException {
        return this.dispatcher.listCatalogs(namespace);
    }

    @Override
    public Catalog[] listCatalogsInfo(Namespace namespace) throws NoSuchMetalakeException {
        return this.dispatcher.listCatalogsInfo(namespace);
    }

    @Override
    public Catalog loadCatalog(NameIdentifier ident) throws NoSuchCatalogException {
        return this.dispatcher.loadCatalog(ident);
    }

    @Override
    public boolean catalogExists(NameIdentifier ident) {
        return this.dispatcher.catalogExists(ident);
    }

    @Override
    public Catalog createCatalog(NameIdentifier ident, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws NoSuchMetalakeException, CatalogAlreadyExistsException {
        this.validateCatalogName(ident.name());
        return this.dispatcher.createCatalog(ident, type, provider, comment, properties);
    }

    @Override
    public Catalog alterCatalog(NameIdentifier ident, CatalogChange ... changes) throws NoSuchCatalogException, IllegalArgumentException {
        Arrays.stream(changes).forEach(c -> {
            if (c instanceof CatalogChange.RenameCatalog) {
                this.validateCatalogName(((CatalogChange.RenameCatalog)c).getNewName());
            }
        });
        return this.dispatcher.alterCatalog(ident, changes);
    }

    @Override
    public boolean dropCatalog(NameIdentifier ident) {
        return this.dispatcher.dropCatalog(ident);
    }

    @Override
    public boolean dropCatalog(NameIdentifier ident, boolean force) throws NonEmptyEntityException, CatalogInUseException {
        return this.dispatcher.dropCatalog(ident, force);
    }

    @Override
    public void testConnection(NameIdentifier ident, Catalog.Type type, String provider, String comment, Map<String, String> properties) throws Exception {
        this.validateCatalogName(ident.name());
        this.dispatcher.testConnection(ident, type, provider, comment, properties);
    }

    @Override
    public void enableCatalog(NameIdentifier ident) throws NoSuchCatalogException {
        this.dispatcher.enableCatalog(ident);
    }

    @Override
    public void disableCatalog(NameIdentifier ident) throws NoSuchCatalogException {
        this.dispatcher.disableCatalog(ident);
    }

    private void validateCatalogName(String name) throws IllegalArgumentException {
        if (RESERVED_WORDS.contains(name.toLowerCase())) {
            throw new IllegalArgumentException("The catalog name '" + name + "' is reserved.");
        }
        if (!name.matches(CATALOG_NAME_PATTERN)) {
            throw new IllegalArgumentException("The catalog name '" + name + "' is illegal.");
        }
    }
}

