/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.wrappedio.impl;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.contract.localfs.LocalFSContract;
import org.apache.hadoop.io.wrappedio.WrappedIO;
import org.apache.hadoop.io.wrappedio.impl.DynamicWrappedIO;
import org.apache.hadoop.io.wrappedio.impl.DynamicWrappedStatistics;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.dynamic.BindingUtils;
import org.apache.hadoop.util.functional.Tuples;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWrappedIO
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestWrappedIO.class);
    private DynamicWrappedIO io;
    private DynamicWrappedStatistics statistics;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.io = new DynamicWrappedIO();
        this.statistics = new DynamicWrappedStatistics();
        this.statistics.iostatisticsContext_reset();
    }

    @Override
    public void teardown() throws Exception {
        super.teardown();
        this.logIOStatisticsContext();
    }

    @Override
    protected AbstractFSContract createContract(Configuration conf) {
        return new LocalFSContract(conf);
    }

    @Test
    public void testClassResolution() throws Throwable {
        LambdaTestUtils.intercept(AssertionError.class, () -> TestWrappedIO.clazz("no.such.class"));
    }

    @Test
    public void testAllMethodsFound() throws Throwable {
        this.io.requireAllMethodsAvailable();
    }

    @Test
    public void testOpenFileOperations() throws Throwable {
        Path path = this.path("testOpenFileOperations");
        int len = 100;
        byte[] data = ContractTestUtils.dataset(100, 97, 26);
        FileSystem fs = this.getFileSystem();
        Serializable iostats = this.statistics.iostatisticsSnapshot_create((Object)ContractTestUtils.file(fs, path, true, data));
        FileStatus st = fs.getFileStatus(path);
        this.describe("reading file " + path);
        try (FSDataInputStream in = DynamicWrappedIO.openFile((FileSystem)fs, (FileStatus)fs.getFileStatus(path), (String)"parquet, columnar, vector, random");){
            ((AbstractIntegerAssert)Assertions.assertThat((int)in.read()).describedAs("first byte", new Object[0])).isEqualTo(97);
            boolean ioStatisticsContextCapability = this.supportsIOStatisticsContext(in);
            if (ioStatisticsContextCapability) {
                LOG.info("Stream has IOStatisticsContext support: {}", (Object)in);
            } else {
                LOG.info("Stream has no IOStatisticsContext support: {}", (Object)in);
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)ioStatisticsContextCapability).describedAs("Retrieved stream capability %s from %s", new Object[]{"fs.capability.iocontext.supported", in})).isEqualTo(WrappedIO.streamCapabilities_hasCapability((Object)in, (String)"fs.capability.iocontext.supported"));
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)ioStatisticsContextCapability).describedAs("Actual stream capability %s from %s", new Object[]{"fs.capability.iocontext.supported", in})).isEqualTo(in.hasCapability("fs.capability.iocontext.supported"));
            this.retrieveAndAggregate(iostats, in);
        }
        var9_8 = null;
        try (FSDataInputStream s = this.openFile(path, null, st, null, null);){
            s.seek(1L);
            s.read();
            this.retrieveAndAggregate(iostats, s);
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        s = this.openFile(path, null, null, 100L, this.map(Tuples.pair((Object)"fs.option.openfile.read.policy", (Object)"random")));
        var9_8 = null;
        try {
            s.seek(90L);
            s.read();
            this.retrieveAndAggregate(iostats, s);
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (var9_8 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        var9_8.addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        String validationPoint = "openfile call";
        try (FSDataInputStream s = this.openFile(path, null, null, null, this.map(Tuples.pair((Object)"fs.option.openfile.length", (Object)200), Tuples.pair((Object)"fs.option.openfile.read.policy", (Object)"random")));){
            validationPoint = "seek()";
            s.seek(110L);
            validationPoint = "readFully()";
            s.readFully(110L, new byte[10], 0, 10);
            Assertions.fail((String)"Expected an EOFException but readFully from %s", (Object[])new Object[]{s});
        }
        catch (EOFException expected) {
            LOG.info("EOF successfully raised, validation point: {}", (Object)validationPoint);
            LOG.debug("stack", (Throwable)expected);
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.io.pathCapabilities_hasPathCapability((Object)fs, path, "fs.capability.bulk.delete")).describedAs("Path capability %s", new Object[]{"fs.capability.bulk.delete"})).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.io.bulkDelete_pageSize(fs, path)).describedAs("bulkDelete_pageSize for %s", new Object[]{path})).isGreaterThanOrEqualTo(1);
        ((ListAssert)Assertions.assertThat((List)this.io.bulkDelete_delete(fs, path.getParent(), (Collection)Lists.newArrayList((Object[])new Path[]{path}))).describedAs("outcome of bulk delete", new Object[0])).isEmpty();
    }

    @Test
    public void testOpenFileNotFound() throws Throwable {
        Path path = this.path("testOpenFileNotFound");
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> this.io.fileSystem_openFile(this.getFileSystem(), path, null, null, null, null));
    }

    @Test
    public void testByteBufferPositionedReadable() throws Throwable {
        Path path = this.path("testByteBufferPositionedReadable");
        int len = 100;
        byte[] data = ContractTestUtils.dataset(100, 97, 26);
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.file(fs, path, true, data);
        this.describe("reading file " + path);
        try (FSDataInputStream in = this.openFile(path, "random", null, 100L, null);){
            if (this.io.byteBufferPositionedReadable_readFullyAvailable((InputStream)in)) {
                LOG.info("ByteBufferPositionedReadable is available in {}", (Object)in);
                ByteBuffer buffer = ByteBuffer.allocate(100);
                this.io.byteBufferPositionedReadable_readFully((InputStream)in, 0L, buffer);
                ((AbstractByteArrayAssert)Assertions.assertThat((byte[])buffer.array()).describedAs("Full buffer read of %s", new Object[]{in})).isEqualTo((Object)data);
                int offset = 10;
                int range = 90;
                buffer = ByteBuffer.allocate(90);
                this.io.byteBufferPositionedReadable_readFully((InputStream)in, 10L, buffer);
                byte[] byteArray = new byte[90];
                in.readFully(10L, byteArray);
                ((AbstractByteArrayAssert)Assertions.assertThat((byte[])buffer.array()).describedAs("Offset buffer read of %s", new Object[]{in})).isEqualTo((Object)byteArray);
                LambdaTestUtils.intercept(EOFException.class, () -> in.readFully(101L, ByteBuffer.allocate(100)));
                LambdaTestUtils.intercept(EOFException.class, () -> this.io.byteBufferPositionedReadable_readFully((InputStream)in, 101L, ByteBuffer.allocate(100)));
            } else {
                LOG.info("ByteBufferPositionedReadable is not available in {}", (Object)in);
                LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> this.io.byteBufferPositionedReadable_readFully((InputStream)in, 0L, ByteBuffer.allocate(100)));
            }
        }
    }

    @Test
    public void testFilesystemIOStatistics() throws Throwable {
        FileSystem fs = this.getFileSystem();
        Serializable iostats = this.statistics.iostatisticsSnapshot_retrieve((Object)fs);
        if (iostats != null) {
            String status = this.statistics.iostatisticsSnapshot_toJsonString(iostats);
            Serializable roundTripped = this.statistics.iostatisticsSnapshot_fromJsonString(status);
            Path path = this.methodPath();
            this.statistics.iostatisticsSnapshot_save(roundTripped, fs, path, true);
            Serializable loaded = this.statistics.iostatisticsSnapshot_load(fs, path);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)loaded).describedAs("loaded statistics from %s", new Object[]{path})).isNotNull()).satisfies(arg_0 -> ((DynamicWrappedStatistics)this.statistics).isIOStatisticsSnapshot(arg_0));
            LOG.info("loaded statistics {}", (Object)this.statistics.iostatistics_toPrettyString((Object)loaded));
        }
    }

    private void retrieveAndAggregate(Serializable iostats, Object object) {
        this.statistics.iostatisticsSnapshot_aggregate(iostats, (Object)this.statistics.iostatisticsSnapshot_retrieve(object));
    }

    private void logIOStatisticsContext() {
        if (this.statistics.iostatisticsContext_enabled()) {
            Serializable iostats = this.statistics.iostatisticsContext_snapshot();
            LOG.info("Context: {}", (Object)this.toPrettyString(iostats));
        } else {
            LOG.info("IOStatisticsContext disabled");
        }
    }

    private String toPrettyString(Object iostats) {
        return this.statistics.iostatistics_toPrettyString(iostats);
    }

    private boolean supportsIOStatisticsContext(Object o) {
        return this.io.streamCapabilities_hasCapability(o, "fs.capability.iocontext.supported");
    }

    private FSDataInputStream openFile(Path path, String policy, FileStatus status, Long length, Map<String, String> options) throws Throwable {
        FSDataInputStream stream = this.io.fileSystem_openFile(this.getFileSystem(), path, policy, status, length, options);
        ((AbstractInputStreamAssert)Assertions.assertThat((InputStream)stream).describedAs("null stream from openFile(%s)", new Object[]{path})).isNotNull();
        return stream;
    }

    private Map<String, String> map(Map.Entry<String, Object> ... tuples) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Object> tuple : tuples) {
            map.put(tuple.getKey(), tuple.getValue().toString());
        }
        return map;
    }

    private static Class<?> clazz(String className) {
        Class clazz = BindingUtils.loadClass((String)className);
        ((ClassAssert)Assertions.assertThat((Class)clazz).describedAs("Class %s not found", new Object[]{className})).isNotNull();
        return clazz;
    }

    @Test
    public void testNoWrappedClass() throws Throwable {
        DynamicWrappedIO broken = new DynamicWrappedIO(this.getClass().getName());
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)broken).describedAs("broken dynamic io %s", new Object[]{broken})).matches(d -> !d.bulkDelete_available())).matches(d -> !d.byteBufferPositionedReadable_available())).matches(d -> !d.fileSystem_openFile_available());
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> broken.bulkDelete_pageSize(fs, path));
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> broken.bulkDelete_delete(fs, path, (Collection)Lists.newArrayList()));
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> broken.fileSystem_openFile(fs, path, "", null, null, null));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)broken.pathCapabilities_hasPathCapability((Object)fs, path, "anything")).describedAs("hasPathCapability(anything) via %s", new Object[]{broken})).isFalse();
        ContractTestUtils.touch(fs, path);
        try (FSDataInputStream in = fs.open(path);){
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)broken.byteBufferPositionedReadable_readFullyAvailable((InputStream)in)).describedAs("byteBufferPositionedReadable_readFullyAvailable on %s", new Object[]{in})).isFalse();
            LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> TestWrappedIO.lambda$testNoWrappedClass$11(broken, (InputStream)in));
        }
    }

    @Test
    public void testMissingClassFallbacks() throws Throwable {
        Path path = this.path("testMissingClassFallbacks");
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.file(fs, path, true, ContractTestUtils.dataset(100, 97, 26));
        DynamicWrappedIO broken = new DynamicWrappedIO(this.getClass().getName());
        try (FSDataInputStream in = DynamicWrappedIO.openFileOnInstance((DynamicWrappedIO)broken, (FileSystem)fs, (FileStatus)fs.getFileStatus(path), (String)"parquet, columnar, vector, random");){
            ((AbstractIntegerAssert)Assertions.assertThat((int)in.read()).describedAs("first byte", new Object[0])).isEqualTo(97);
        }
    }

    @Test
    public void testNonStaticMethods() throws Throwable {
        LambdaTestUtils.intercept(IllegalStateException.class, () -> new DynamicWrappedIO(NonStaticBulkDeleteMethods.class.getName()));
    }

    private static /* synthetic */ void lambda$testNoWrappedClass$11(DynamicWrappedIO broken, InputStream in) throws Exception {
        broken.byteBufferPositionedReadable_readFully(in, 0L, ByteBuffer.allocate(1));
    }

    private static final class NonStaticBulkDeleteMethods {
        private NonStaticBulkDeleteMethods() {
        }

        public int bulkDelete_pageSize(FileSystem ignoredFs, Path ignoredPath) {
            return 0;
        }

        public List<Map.Entry<Path, String>> bulkDelete_delete(FileSystem ignoredFs, Path ignoredBase, Collection<Path> ignoredPaths) {
            return null;
        }
    }
}

