/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.ShadingStore;
import org.ojalgo.scalar.Scalar;

final class LowerTriangularStore<N extends Number>
extends ShadingStore<N> {
    private final boolean myUnitDiagonal;

    private LowerTriangularStore(int aRowDim, int aColDim, MatrixStore<N> base) {
        this(base, true);
        ProgrammingError.throwForIllegalInvocation();
    }

    LowerTriangularStore(MatrixStore<N> base, boolean unitDiagonal) {
        super(base, (int)base.countRows(), (int)Math.min(base.countRows(), base.countColumns()));
        this.myUnitDiagonal = unitDiagonal;
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row < col) {
            return PrimitiveMath.ZERO;
        }
        if (this.myUnitDiagonal && row == col) {
            return PrimitiveMath.ONE;
        }
        return this.getBase().doubleValue(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        return col;
    }

    @Override
    public N get(long row, long col) {
        if (row < col) {
            return this.physical().scalar().zero().getNumber();
        }
        if (this.myUnitDiagonal && row == col) {
            return this.physical().scalar().one().getNumber();
        }
        return this.getBase().get(row, col);
    }

    @Override
    public int limitOfRow(int row) {
        return row + 1;
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        if (row < col) {
            return this.physical().scalar().zero();
        }
        if (this.myUnitDiagonal && row == col) {
            return this.physical().scalar().one();
        }
        return this.getBase().toScalar(row, col);
    }
}

