/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class UpdataDatabasePropFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdataDatabasePropFunction.class);
    private final String database;
    private final long dbId;
    private final String prop;
    private final String propValue;

    public UpdataDatabasePropFunction(String database, long dbId, String prop, String propValue) {
        this.database = database;
        this.dbId = dbId;
        this.prop = prop;
        this.propValue = propValue;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("dbId", (Object)this.dbId).addValue("key", (Object)this.prop).addValue("value", (Object)this.propValue);
        NamedParameterJdbcTemplate jdbcTemplate = jdbcResource.getJdbcTemplate();
        String value = (String)jdbcTemplate.query("SELECT \"PARAM_VALUE\" FROM \"DATABASE_PARAMS\" WHERE \"PARAM_KEY\" = :key AND \"DB_ID\" = :dbId", (SqlParameterSource)params, rs -> rs.next() ? rs.getString("PARAM_VALUE") : null);
        int count = 1;
        if (value != null) {
            if (value.equals(this.propValue)) {
                LOG.info("Database property: {} with value: {} already updated for db: {}", new Object[]{this.prop, this.propValue, this.database});
            } else {
                count = jdbcTemplate.update("UPDATE \"DATABASE_PARAMS\" SET \"PARAM_VALUE\" = :value WHERE \"DB_ID\" = :dbId AND \"PARAM_KEY\" = :key", (SqlParameterSource)params);
            }
        } else {
            count = jdbcTemplate.update("INSERT INTO \"DATABASE_PARAMS\" VALUES (:dbId, :key, :value)", (SqlParameterSource)params);
        }
        if (count != 1) {
            throw new RuntimeException("DATABASE_PARAMS is corrupted for database: " + this.database);
        }
        return null;
    }
}

