/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.MaterializedViewMetadata;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTezModelRelMetadataProvider;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdRowCount;

public class HiveIncrementalRelMdRowCount
extends HiveRelMdRowCount {
    private final Map<String, SourceTable> sourceTableMap;

    public static JaninoRelMetadataProvider createMetadataProvider(RelOptMaterialization materialization) {
        return JaninoRelMetadataProvider.of((RelMetadataProvider)ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)HiveIncrementalRelMdRowCount.source(materialization), (Object)HiveTezModelRelMetadataProvider.DEFAULT)));
    }

    public static RelMetadataProvider source(RelOptMaterialization materialization) {
        MaterializedViewMetadata mvMetadata = HiveMaterializedViewUtils.extractTable(materialization).getMVMetadata();
        HashMap<String, SourceTable> sourceTableMap = new HashMap<String, SourceTable>(mvMetadata.getSourceTables().size());
        for (SourceTable sourceTable : mvMetadata.getSourceTables()) {
            org.apache.hadoop.hive.metastore.api.Table table = sourceTable.getTable();
            sourceTableMap.put(TableName.getQualified((String)table.getCatName(), (String)table.getDbName(), (String)table.getTableName()), sourceTable);
        }
        return ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.ROW_COUNT.method, (MetadataHandler)new HiveIncrementalRelMdRowCount(sourceTableMap));
    }

    public HiveIncrementalRelMdRowCount(Map<String, SourceTable> sourceTableMap) {
        this.sourceTableMap = sourceTableMap;
    }

    public Double getRowCount(TableScan rel, RelMetadataQuery mq) {
        if (!(rel instanceof HiveTableScan)) {
            return super.getRowCount(rel, mq);
        }
        HiveTableScan tableScan = (HiveTableScan)rel;
        RelOptHiveTable relOptHiveTable = (RelOptHiveTable)tableScan.getTable();
        Table table = relOptHiveTable.getHiveTableMD();
        String fullyQualifiedName = TableName.getQualified((String)table.getCatName(), (String)table.getDbName(), (String)table.getTableName());
        SourceTable sourceTable = this.sourceTableMap.get(fullyQualifiedName);
        if (sourceTable == null) {
            return super.getRowCount(rel, mq);
        }
        HiveStorageHandler storageHandler = table.getStorageHandler();
        if (storageHandler != null && storageHandler.areSnapshotsSupported()) {
            SnapshotContext since = new SnapshotContext(Long.parseLong(table.getVersionIntervalFrom()));
            return StreamSupport.stream(storageHandler.getSnapshotContexts(table, since).spliterator(), false).mapToDouble(SnapshotContext::getAddedRowCount).sum();
        }
        return sourceTable.getInsertedCount();
    }
}

