/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.scheduled;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.scheduled.IScheduledQueryMaintenanceService;

public class ScheduledQueryExecutionContext {
    public final ExecutorService executor;
    public final IScheduledQueryMaintenanceService schedulerService;
    public final HiveConf conf;
    public final String executorHostName;

    public ScheduledQueryExecutionContext(ExecutorService executor, HiveConf conf, IScheduledQueryMaintenanceService service) {
        this.executor = executor;
        this.conf = conf;
        this.schedulerService = service;
        try {
            this.executorHostName = InetAddress.getLocalHost().getHostName();
            if (this.executorHostName == null) {
                throw new RuntimeException("Hostname is null; Can't function without a valid hostname!");
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Can't function without a valid hostname!", e);
        }
    }

    public long getIdleSleepTime() {
        return this.conf.getTimeVar(HiveConf.ConfVars.HIVE_SCHEDULED_QUERIES_EXECUTOR_IDLE_SLEEP_TIME, TimeUnit.MILLISECONDS);
    }

    public long getProgressReporterSleepTime() {
        return this.conf.getTimeVar(HiveConf.ConfVars.HIVE_SCHEDULED_QUERIES_EXECUTOR_PROGRESS_REPORT_INTERVAL, TimeUnit.MILLISECONDS);
    }

    public int getNumberOfExecutors() {
        return this.conf.getIntVar(HiveConf.ConfVars.HIVE_SCHEDULED_QUERIES_MAX_EXECUTORS);
    }
}

