/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHeaderElementIterator;
import org.apache.hc.core5.http.message.BasicHeaderIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicHeaderElementIterator {
    TestBasicHeaderElementIterator() {
    }

    @Test
    void testMultiHeader() {
        Header[] headers = new Header[]{new BasicHeader("Name", (Object)"value0"), new BasicHeader("Name", (Object)"value1")};
        BasicHeaderElementIterator hei = new BasicHeaderElementIterator((Iterator)new BasicHeaderIterator(headers, "Name"));
        Assertions.assertTrue((boolean)hei.hasNext());
        HeaderElement elem = (HeaderElement)hei.next();
        Assertions.assertEquals((Object)"value0", (Object)elem.getName(), (String)"The two header values must be equal");
        Assertions.assertTrue((boolean)hei.hasNext());
        elem = (HeaderElement)hei.next();
        Assertions.assertEquals((Object)"value1", (Object)elem.getName(), (String)"The two header values must be equal");
        Assertions.assertFalse((boolean)hei.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> TestBasicHeaderElementIterator.lambda$testMultiHeader$0((Iterator)hei));
        Assertions.assertFalse((boolean)hei.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> TestBasicHeaderElementIterator.lambda$testMultiHeader$1((Iterator)hei));
    }

    @Test
    void testMultiHeaderSameLine() {
        Header[] headers = new Header[]{new BasicHeader("name", (Object)"value0,value1"), new BasicHeader("nAme", (Object)"cookie1=1,cookie2=2")};
        BasicHeaderElementIterator hei = new BasicHeaderElementIterator((Iterator)new BasicHeaderIterator(headers, "Name"));
        HeaderElement elem = (HeaderElement)hei.next();
        Assertions.assertEquals((Object)"value0", (Object)elem.getName(), (String)"The two header values must be equal");
        elem = (HeaderElement)hei.next();
        Assertions.assertEquals((Object)"value1", (Object)elem.getName(), (String)"The two header values must be equal");
        elem = (HeaderElement)hei.next();
        Assertions.assertEquals((Object)"cookie1", (Object)elem.getName(), (String)"The two header values must be equal");
        Assertions.assertEquals((Object)"1", (Object)elem.getValue(), (String)"The two header values must be equal");
        elem = (HeaderElement)hei.next();
        Assertions.assertEquals((Object)"cookie2", (Object)elem.getName(), (String)"The two header values must be equal");
        Assertions.assertEquals((Object)"2", (Object)elem.getValue(), (String)"The two header values must be equal");
    }

    @Test
    void testFringeCases() {
        Header[] headers = new Header[]{new BasicHeader("Name", null), new BasicHeader("Name", (Object)"    "), new BasicHeader("Name", (Object)",,,")};
        BasicHeaderElementIterator hei = new BasicHeaderElementIterator((Iterator)new BasicHeaderIterator(headers, "Name"));
        Assertions.assertFalse((boolean)hei.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> TestBasicHeaderElementIterator.lambda$testFringeCases$2((Iterator)hei));
        Assertions.assertFalse((boolean)hei.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> TestBasicHeaderElementIterator.lambda$testFringeCases$3((Iterator)hei));
    }

    private static /* synthetic */ void lambda$testFringeCases$3(Iterator hei) throws Throwable {
        HeaderElement cfr_ignored_0 = (HeaderElement)hei.next();
    }

    private static /* synthetic */ void lambda$testFringeCases$2(Iterator hei) throws Throwable {
        HeaderElement cfr_ignored_0 = (HeaderElement)hei.next();
    }

    private static /* synthetic */ void lambda$testMultiHeader$1(Iterator hei) throws Throwable {
        HeaderElement cfr_ignored_0 = (HeaderElement)hei.next();
    }

    private static /* synthetic */ void lambda$testMultiHeader$0(Iterator hei) throws Throwable {
        HeaderElement cfr_ignored_0 = (HeaderElement)hei.next();
    }
}

