/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hc.core5.http.WritableByteChannelMock;
import org.apache.hc.core5.http.impl.BasicHttpTransportMetrics;
import org.apache.hc.core5.http.impl.nio.ChunkEncoder;
import org.apache.hc.core5.http.impl.nio.CodecTestUtils;
import org.apache.hc.core5.http.impl.nio.SessionOutputBufferImpl;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.nio.SessionOutputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestChunkEncoder {
    TestChunkEncoder() {
    }

    @Test
    void testBasicCoding() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkEncoder encoder = new ChunkEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics);
        encoder.write(CodecTestUtils.wrap("12345"));
        encoder.write(CodecTestUtils.wrap("678"));
        encoder.write(CodecTestUtils.wrap("90"));
        encoder.complete();
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"5\r\n12345\r\n3\r\n678\r\n2\r\n90\r\n0\r\n\r\n", (Object)s);
        Assertions.assertEquals((Object)"[chunk-coded; completed: true]", (Object)encoder.toString());
    }

    @Test
    void testChunkNoExceed() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 16);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkEncoder encoder = new ChunkEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics);
        encoder.write(CodecTestUtils.wrap("1234"));
        encoder.complete();
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"4\r\n1234\r\n0\r\n\r\n", (Object)s);
    }

    @Test
    void testLimitedChannel() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(16, 16);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(16, 16);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkEncoder encoder = new ChunkEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics);
        channel.write(CodecTestUtils.wrap("0123456789ABCDEF"));
        outbuf.write(CodecTestUtils.wrap("0123456789ABCDEF"));
        ByteBuffer src = CodecTestUtils.wrap("0123456789ABCDEF");
        Assertions.assertEquals((int)0, (int)encoder.write(src));
        Assertions.assertEquals((int)0, (int)encoder.write(src));
        Assertions.assertEquals((int)0, (int)encoder.write(src));
        channel.reset();
        outbuf.flush((WritableByteChannel)channel);
        channel.reset();
        Assertions.assertEquals((int)10, (int)encoder.write(src));
        channel.flush();
        Assertions.assertEquals((int)6, (int)encoder.write(src));
        channel.flush();
        Assertions.assertEquals((int)0, (int)encoder.write(src));
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"4\r\n0123\r\n4\r\n4567\r\n2\r\n89\r\n4\r\nABCD\r\n2\r\nEF\r\n", (Object)s);
    }

    @Test
    void testBufferFragments() throws Exception {
        WritableByteChannelMock channel = (WritableByteChannelMock)Mockito.spy((Object)new WritableByteChannelMock(1024));
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 1024);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkEncoder encoder = new ChunkEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 1024);
        Assertions.assertEquals((int)16, (int)encoder.write(CodecTestUtils.wrap("0123456789ABCDEF")));
        Assertions.assertEquals((int)16, (int)encoder.write(CodecTestUtils.wrap("0123456789ABCDEF")));
        Assertions.assertEquals((int)16, (int)encoder.write(CodecTestUtils.wrap("0123456789ABCDEF")));
        ((WritableByteChannelMock)Mockito.verify((Object)channel, (VerificationMode)Mockito.never())).write((ByteBuffer)ArgumentMatchers.any());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"10\r\n0123456789ABCDEF\r\n10\r\n0123456789ABCDEF\r\n10\r\n0123456789ABCDEF\r\n", (Object)s);
    }

    @Test
    void testChunkExceed() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(16, 16);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkEncoder encoder = new ChunkEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics);
        ByteBuffer src = CodecTestUtils.wrap("0123456789ABCDEF");
        Assertions.assertEquals((int)16, (int)encoder.write(src));
        Assertions.assertEquals((int)0, (int)src.remaining());
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"4\r\n0123\r\n4\r\n4567\r\n4\r\n89AB\r\n4\r\nCDEF\r\n", (Object)s);
    }

    @Test
    void testCodingEmptyBuffer() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkEncoder encoder = new ChunkEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics);
        encoder.write(CodecTestUtils.wrap("12345"));
        encoder.write(CodecTestUtils.wrap("678"));
        encoder.write(CodecTestUtils.wrap("90"));
        ByteBuffer empty = ByteBuffer.allocate(100);
        empty.flip();
        encoder.write(empty);
        encoder.write(null);
        encoder.complete();
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"5\r\n12345\r\n3\r\n678\r\n2\r\n90\r\n0\r\n\r\n", (Object)s);
    }

    @Test
    void testCodingCompleted() throws Exception {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkEncoder encoder = new ChunkEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics);
        encoder.write(CodecTestUtils.wrap("12345"));
        encoder.write(CodecTestUtils.wrap("678"));
        encoder.write(CodecTestUtils.wrap("90"));
        encoder.complete();
        ByteBuffer wrapped = CodecTestUtils.wrap("more stuff");
        Assertions.assertThrows(IllegalStateException.class, () -> encoder.write(wrapped));
        Assertions.assertThrows(IllegalStateException.class, () -> encoder.complete());
    }

    @Test
    void testInvalidConstructor() {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        Assertions.assertThrows(NullPointerException.class, () -> new ChunkEncoder(null, null, null));
        Assertions.assertThrows(NullPointerException.class, () -> new ChunkEncoder((WritableByteChannel)channel, null, null));
        Assertions.assertThrows(NullPointerException.class, () -> TestChunkEncoder.lambda$testInvalidConstructor$4(channel, (SessionOutputBuffer)outbuf));
    }

    @Test
    void testTrailers() throws IOException {
        WritableByteChannelMock channel = new WritableByteChannelMock(64);
        SessionOutputBufferImpl outbuf = new SessionOutputBufferImpl(1024, 128);
        BasicHttpTransportMetrics metrics = new BasicHttpTransportMetrics();
        ChunkEncoder encoder = new ChunkEncoder((WritableByteChannel)channel, (SessionOutputBuffer)outbuf, metrics, 0);
        encoder.write(CodecTestUtils.wrap("1"));
        encoder.write(CodecTestUtils.wrap("23"));
        encoder.complete(Arrays.asList(new BasicHeader("E", (Object)""), new BasicHeader("Y", (Object)"Z")));
        outbuf.flush((WritableByteChannel)channel);
        String s = channel.dump(StandardCharsets.US_ASCII);
        Assertions.assertTrue((boolean)encoder.isCompleted());
        Assertions.assertEquals((Object)"1\r\n1\r\n2\r\n23\r\n0\r\nE: \r\nY: Z\r\n\r\n", (Object)s);
        Assertions.assertEquals((Object)"[chunk-coded; completed: true]", (Object)encoder.toString());
    }

    private static /* synthetic */ void lambda$testInvalidConstructor$4(WritableByteChannelMock channel, SessionOutputBuffer outbuf) throws Throwable {
        new ChunkEncoder((WritableByteChannel)channel, outbuf, null);
    }
}

