/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.process;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.amoro.exception.AmoroRuntimeException;

public class SimpleFuture {
    private final CompletableFuture<?> completedFuture = new CompletableFuture();
    private final Map<Runnable, CompletableFuture<?>> callbackMap = new LinkedHashMap();
    private CompletableFuture<?> triggerFuture;
    private CompletableFuture<?> callbackFuture;

    public SimpleFuture() {
        this(new CompletableFuture());
    }

    protected SimpleFuture(CompletableFuture<?> triggerFuture) {
        this.triggerFuture = triggerFuture;
        this.callbackFuture = triggerFuture;
        this.whenCompleted(() -> {});
    }

    public void whenCompleted(Runnable runnable) {
        this.callbackFuture = this.callbackFuture.whenComplete((v, e) -> {
            if (e == null) {
                runnable.run();
                if (this.callbackMap.get(runnable) == this.callbackFuture) {
                    this.completedFuture.complete(null);
                }
            } else {
                throw AmoroRuntimeException.wrap(e);
            }
        });
        this.callbackMap.put(runnable, this.callbackFuture);
    }

    public boolean isDone() {
        return this.completedFuture.isDone();
    }

    public void reset() {
        this.triggerFuture = new CompletableFuture();
        this.callbackFuture = this.triggerFuture;
        this.callbackMap.keySet().forEach(this::whenCompleted);
    }

    public void complete() {
        try {
            CompletableFuture<?> originalFuture = this.triggerFuture;
            if (this.triggerFuture.complete(null) && this.triggerFuture == originalFuture) {
                this.callbackFuture.get();
            }
        }
        catch (Throwable throwable) {
            throw this.normalize(throwable);
        }
    }

    public void join() {
        try {
            this.completedFuture.join();
        }
        catch (Throwable throwable) {
            throw this.normalize(throwable);
        }
    }

    private AmoroRuntimeException normalize(Throwable throwable) {
        if (throwable instanceof ExecutionException && throwable.getCause() != null) {
            return AmoroRuntimeException.wrap(throwable.getCause());
        }
        return AmoroRuntimeException.wrap(throwable);
    }

    public SimpleFuture or(SimpleFuture anotherFuture) {
        return new SimpleFuture(CompletableFuture.anyOf(this.completedFuture, anotherFuture.completedFuture));
    }

    public SimpleFuture and(SimpleFuture anotherFuture) {
        return new SimpleFuture(CompletableFuture.allOf(this.completedFuture, anotherFuture.completedFuture));
    }

    public static SimpleFuture allOf(List<SimpleFuture> futures) {
        return new SimpleFuture(CompletableFuture.allOf((CompletableFuture[])futures.stream().map(f -> f.completedFuture).toArray(CompletableFuture[]::new)));
    }

    public static SimpleFuture anyOf(List<SimpleFuture> futures) {
        return new SimpleFuture(CompletableFuture.anyOf((CompletableFuture[])futures.stream().map(f -> f.completedFuture).toArray(CompletableFuture[]::new)));
    }
}

