/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.terminal;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.config.ConfigOptions;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.catalog.CatalogManager;
import org.apache.amoro.server.catalog.CatalogType;
import org.apache.amoro.server.dashboard.model.LatestSessionInfo;
import org.apache.amoro.server.dashboard.model.LogInfo;
import org.apache.amoro.server.dashboard.model.SqlResult;
import org.apache.amoro.server.dashboard.utils.AmsUtil;
import org.apache.amoro.server.terminal.ExecutionStatus;
import org.apache.amoro.server.terminal.TerminalSessionContext;
import org.apache.amoro.server.terminal.TerminalSessionFactory;
import org.apache.amoro.server.terminal.kyuubi.KyuubiTerminalSessionFactory;
import org.apache.amoro.server.terminal.local.LocalSessionFactory;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.CatalogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalManager {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalManager.class);
    private static final int SESSION_TIMEOUT_CHECK_INTERVAL = 300000;
    private final Configurations serviceConfig;
    private final AtomicLong threadPoolCount = new AtomicLong();
    private final CatalogManager catalogManager;
    private final TerminalSessionFactory sessionFactory;
    private final int resultLimits;
    private final boolean stopOnError;
    private final int sessionTimeout;
    private final Object sessionMapLock = new Object();
    private final Map<String, TerminalSessionContext> sessionMap = Maps.newHashMap();
    private final Thread gcThread;
    private volatile boolean running = true;
    private final ThreadPoolExecutor executionPool = new ThreadPoolExecutor(1, 50, 30L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), r -> new Thread(null, r, "terminal-execute-" + this.threadPoolCount.incrementAndGet()));

    public TerminalManager(Configurations conf, CatalogManager catalogManager) {
        this.serviceConfig = conf;
        this.catalogManager = catalogManager;
        this.resultLimits = conf.getInteger(AmoroManagementConf.TERMINAL_RESULT_LIMIT);
        this.stopOnError = conf.getBoolean(AmoroManagementConf.TERMINAL_STOP_ON_ERROR);
        this.sessionTimeout = (int)((Duration)conf.get(AmoroManagementConf.TERMINAL_SESSION_TIMEOUT)).toMinutes();
        this.sessionFactory = this.loadTerminalSessionFactory(conf);
        this.gcThread = new Thread(new SessionCleanTask());
        this.gcThread.setName("terminal-session-gc");
        this.gcThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeScript(String terminalId, String catalog, String script) {
        CatalogMeta catalogMeta = this.catalogManager.getCatalogMeta(catalog);
        TableMetaStore metaStore = this.getCatalogTableMetaStore(catalogMeta);
        String sessionId = this.getSessionId(terminalId, metaStore, catalog);
        String connectorType = this.catalogConnectorType(catalogMeta);
        this.applyClientProperties(catalogMeta);
        Configurations configuration = new Configurations();
        configuration.set(AmoroManagementConf.TERMINAL_SENSITIVE_CONF_KEYS, this.serviceConfig.get(AmoroManagementConf.TERMINAL_SENSITIVE_CONF_KEYS));
        configuration.setInteger(TerminalSessionFactory.SessionConfigOptions.FETCH_SIZE, this.resultLimits);
        configuration.set(TerminalSessionFactory.SessionConfigOptions.CATALOGS, (Object)Lists.newArrayList((Object[])new String[]{catalog}));
        configuration.set(TerminalSessionFactory.SessionConfigOptions.catalogConnector(catalog), (Object)connectorType);
        configuration.set(TerminalSessionFactory.SessionConfigOptions.CATALOG_URL_BASE, (Object)AmsUtil.getAMSThriftAddress(this.serviceConfig, "TableMetastore"));
        for (String key : catalogMeta.getCatalogProperties().keySet()) {
            String value = (String)catalogMeta.getCatalogProperties().get(key);
            configuration.set(TerminalSessionFactory.SessionConfigOptions.catalogProperty(catalog, key), (Object)value);
        }
        Object object = this.sessionMapLock;
        synchronized (object) {
            this.sessionMap.compute(sessionId, (id, ctx) -> {
                if (ctx == null) {
                    return new TerminalSessionContext((String)id, metaStore, this.executionPool, this.sessionFactory, configuration);
                }
                return ctx.sessionConfiguration().equals((Object)configuration) ? ctx : new TerminalSessionContext((String)id, metaStore, this.executionPool, this.sessionFactory, configuration);
            });
        }
        TerminalSessionContext context = this.sessionMap.get(sessionId);
        if (!context.isReadyToExecute()) {
            throw new IllegalStateException("current session is not ready to execute script. status:" + (Object)((Object)context.getStatus()));
        }
        context.submit(catalog, script, this.resultLimits, this.stopOnError);
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogInfo getExecutionLog(String sessionId) {
        TerminalSessionContext sessionContext;
        if (sessionId == null) {
            return new LogInfo(ExecutionStatus.Expired.name(), Lists.newArrayList());
        }
        Object object = this.sessionMapLock;
        synchronized (object) {
            sessionContext = this.sessionMap.get(sessionId);
        }
        if (sessionContext == null) {
            return new LogInfo(ExecutionStatus.Expired.name(), Lists.newArrayList());
        }
        return new LogInfo(sessionContext.getStatus().name(), sessionContext.getLogs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SqlResult> getExecutionResults(String sessionId) {
        TerminalSessionContext context;
        if (sessionId == null) {
            return Lists.newArrayList();
        }
        Object object = this.sessionMapLock;
        synchronized (object) {
            context = this.sessionMap.get(sessionId);
        }
        if (context == null) {
            return Lists.newArrayList();
        }
        return context.getStatementResults().stream().map(statement -> {
            SqlResult sql = new SqlResult();
            sql.setId("line:" + statement.getLineNumber() + " - " + statement.getStatement());
            sql.setColumns(statement.getColumns());
            sql.setRowData(statement.getDataAsStringList());
            sql.setStatus(statement.isSuccess() ? ExecutionStatus.Finished.name() : ExecutionStatus.Failed.name());
            return sql;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExecution(String sessionId) {
        TerminalSessionContext context;
        if (sessionId == null) {
            return;
        }
        Object object = this.sessionMapLock;
        synchronized (object) {
            context = this.sessionMap.get(sessionId);
        }
        if (context != null) {
            context.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LatestSessionInfo getLastSessionInfo(String terminalId) {
        String prefix = terminalId + "-";
        long lastExecutionTime = -1L;
        String sessionId = "";
        String script = "";
        Object object = this.sessionMapLock;
        synchronized (object) {
            for (String sid : this.sessionMap.keySet()) {
                TerminalSessionContext context;
                if (!sid.startsWith(prefix) || (context = this.sessionMap.get(sid)) == null || lastExecutionTime >= context.lastExecutionTime()) continue;
                lastExecutionTime = context.lastExecutionTime();
                sessionId = sid;
                script = context.lastScript();
            }
        }
        return new LatestSessionInfo(sessionId, script);
    }

    public void dispose() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.gcThread != null) {
            this.gcThread.interrupt();
        }
        this.executionPool.shutdown();
    }

    private String catalogConnectorType(CatalogMeta catalogMeta) {
        String catalogType = catalogMeta.getCatalogType();
        Set tableFormatSet = CatalogUtil.tableFormats((CatalogMeta)catalogMeta);
        if (catalogType.equalsIgnoreCase(CatalogType.AMS.name())) {
            if (tableFormatSet.size() > 1) {
                return "unified";
            }
            if (tableFormatSet.contains(TableFormat.MIXED_ICEBERG)) {
                return "mixed_iceberg";
            }
            if (tableFormatSet.contains(TableFormat.ICEBERG)) {
                return "iceberg";
            }
        } else if (catalogType.equalsIgnoreCase(CatalogType.HIVE.name()) || catalogType.equalsIgnoreCase(CatalogType.HADOOP.name())) {
            if (tableFormatSet.size() > 1) {
                return "unified";
            }
            if (tableFormatSet.contains(TableFormat.MIXED_ICEBERG)) {
                return "mixed_iceberg";
            }
            if (tableFormatSet.contains(TableFormat.MIXED_HIVE)) {
                return "mixed_hive";
            }
            if (tableFormatSet.contains(TableFormat.ICEBERG)) {
                return "iceberg";
            }
            if (tableFormatSet.contains(TableFormat.PAIMON)) {
                return "paimon";
            }
        } else {
            if (catalogType.equalsIgnoreCase(CatalogType.CUSTOM.name())) {
                return "iceberg";
            }
            if (catalogType.equalsIgnoreCase(CatalogType.GLUE.name())) {
                return "iceberg";
            }
        }
        throw new IllegalStateException("unknown catalog type: " + catalogType);
    }

    private String getSessionId(String loginId, TableMetaStore auth, String catalog) {
        String authName = auth.getHadoopUsername();
        if (auth.isKerberosAuthMethod()) {
            authName = auth.getKrbPrincipal();
        }
        String sessionId = loginId + "-" + auth.getAuthMethod() + "-" + authName + "-" + catalog;
        sessionId = sessionId.replace("/", "_");
        return sessionId;
    }

    private TableMetaStore getCatalogTableMetaStore(CatalogMeta catalogMeta) {
        String authType;
        Map storageConfigs;
        TableMetaStore.Builder builder = TableMetaStore.builder();
        if (catalogMeta.getStorageConfigs() != null && "Hadoop".equalsIgnoreCase(CatalogUtil.getCompatibleStorageType((Map)(storageConfigs = catalogMeta.getStorageConfigs())))) {
            builder.withBase64MetaStoreSite((String)catalogMeta.getStorageConfigs().get("hive.site")).withBase64CoreSite((String)catalogMeta.getStorageConfigs().get("hadoop.core.site")).withBase64HdfsSite((String)catalogMeta.getStorageConfigs().get("hadoop.hdfs.site"));
        }
        if ("simple".equalsIgnoreCase(authType = (String)catalogMeta.getAuthConfigs().get("auth.type"))) {
            builder.withSimpleAuth((String)catalogMeta.getAuthConfigs().get("auth.simple.hadoop_username"));
        } else if ("kerberos".equalsIgnoreCase(authType)) {
            builder.withBase64Auth((String)catalogMeta.getAuthConfigs().get("auth.type"), (String)catalogMeta.getAuthConfigs().get("auth.simple.hadoop_username"), (String)catalogMeta.getAuthConfigs().get("auth.kerberos.keytab"), (String)catalogMeta.getAuthConfigs().get("auth.kerberos.krb5"), (String)catalogMeta.getAuthConfigs().get("auth.kerberos.principal"));
        }
        return builder.build();
    }

    private TerminalSessionFactory loadTerminalSessionFactory(Configurations conf) {
        TerminalSessionFactory factory;
        String backendImplement;
        String backend = (String)conf.get(AmoroManagementConf.TERMINAL_BACKEND);
        if (backend == null) {
            throw new IllegalArgumentException("lack terminal implement config.");
        }
        switch (backend.toLowerCase()) {
            case "local": {
                backendImplement = LocalSessionFactory.class.getName();
                break;
            }
            case "kyuubi": {
                backendImplement = KyuubiTerminalSessionFactory.class.getName();
                break;
            }
            case "custom": {
                Optional customFactoryClz = conf.getOptional(AmoroManagementConf.TERMINAL_SESSION_FACTORY);
                if (!customFactoryClz.isPresent()) {
                    throw new IllegalArgumentException("terminal backend type is custom, but terminal session factory is not configured");
                }
                backendImplement = (String)customFactoryClz.get();
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal terminal implement: " + backend + ", local, kyuubi, custom is available");
            }
        }
        try {
            factory = (TerminalSessionFactory)Class.forName(backendImplement).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("failed to init session factory", e);
        }
        String factoryPropertiesPrefix = "terminal." + backend + ".";
        Configurations configuration = new Configurations();
        for (String key : conf.keySet()) {
            if (!key.startsWith("terminal.")) continue;
            String value = conf.getValue(ConfigOptions.key((String)key).stringType().noDefaultValue());
            key = key.substring(factoryPropertiesPrefix.length());
            configuration.setString(key, value);
        }
        configuration.set(AmoroManagementConf.TERMINAL_SENSITIVE_CONF_KEYS, this.serviceConfig.get(AmoroManagementConf.TERMINAL_SENSITIVE_CONF_KEYS));
        configuration.set(TerminalSessionFactory.FETCH_SIZE, (Object)this.resultLimits);
        factory.initialize(configuration);
        return factory;
    }

    private void applyClientProperties(CatalogMeta catalogMeta) {
        Set formats = CatalogUtil.tableFormats((CatalogMeta)catalogMeta);
        String catalogType = catalogMeta.getCatalogType();
        if (formats.contains(TableFormat.ICEBERG)) {
            if ("ams".equalsIgnoreCase(catalogType)) {
                catalogMeta.putToCatalogProperties("warehouse", catalogMeta.getCatalogName());
            } else if (!catalogMeta.getCatalogProperties().containsKey("catalog-impl")) {
                catalogMeta.putToCatalogProperties("type", catalogType);
            }
        } else if (formats.contains(TableFormat.PAIMON) && "hive".equals(catalogType)) {
            catalogMeta.putToCatalogProperties("metastore", catalogType);
        }
    }

    private class SessionCleanTask
    implements Runnable {
        private static final long MINUTE_IN_MILLIS = 60000L;

        private SessionCleanTask() {
        }

        @Override
        public void run() {
            LOG.info("Terminal Session Clean Task started");
            LOG.info("Terminal Session Clean Task, check interval: 300000 ms");
            LOG.info("Terminal Session Timeout: {} minutes", (Object)TerminalManager.this.sessionTimeout);
            while (TerminalManager.this.running) {
                try {
                    List<TerminalSessionContext> sessionToRelease = this.checkIdleSession();
                    sessionToRelease.forEach(this::releaseSession);
                    if (!sessionToRelease.isEmpty()) {
                        LOG.info("Terminal Session release count: {}", (Object)sessionToRelease.size());
                    }
                }
                catch (Throwable t) {
                    LOG.error("error when check and release session", t);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(300000L);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted when sleep", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<TerminalSessionContext> checkIdleSession() {
            long timeoutInMillis = (long)TerminalManager.this.sessionTimeout * 60000L;
            Object object = TerminalManager.this.sessionMapLock;
            synchronized (object) {
                ArrayList sessionToRelease = Lists.newArrayList();
                for (String sessionId : TerminalManager.this.sessionMap.keySet()) {
                    long idleTime;
                    TerminalSessionContext sessionContext = (TerminalSessionContext)TerminalManager.this.sessionMap.get(sessionId);
                    if (!sessionContext.isIdleStatus() || (idleTime = System.currentTimeMillis() - sessionContext.lastExecutionTime()) <= timeoutInMillis) continue;
                    sessionToRelease.add(sessionContext);
                }
                sessionToRelease.forEach(s -> {
                    TerminalSessionContext cfr_ignored_0 = (TerminalSessionContext)TerminalManager.this.sessionMap.remove(s.getSessionId());
                });
                return sessionToRelease;
            }
        }

        private void releaseSession(TerminalSessionContext sessionContext) {
            try {
                sessionContext.release();
            }
            catch (Throwable t) {
                LOG.error("error when release session: {}", (Object)sessionContext.getSessionId(), (Object)t);
            }
        }
    }
}

