/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga.link;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.extension.nga.link.FeatureTileLink;
import mil.nga.geopackage.extension.nga.link.FeatureTileLinkKey;

public class FeatureTileLinkDao
extends GeoPackageDao<FeatureTileLink, FeatureTileLinkKey> {
    public static FeatureTileLinkDao create(GeoPackageCore geoPackage) {
        return FeatureTileLinkDao.create(geoPackage.getDatabase());
    }

    public static FeatureTileLinkDao create(GeoPackageCoreConnection db) {
        return (FeatureTileLinkDao)((Object)GeoPackageDao.createDao(db, FeatureTileLink.class));
    }

    public FeatureTileLinkDao(ConnectionSource connectionSource, Class<FeatureTileLink> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public FeatureTileLink queryForId(FeatureTileLinkKey key) throws SQLException {
        FeatureTileLink featureTileLink = null;
        if (key != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("feature_table_name", key.getFeatureTableName());
            fieldValues.put("tile_table_name", key.getTileTableName());
            List results = this.queryForFieldValues(fieldValues);
            if (!results.isEmpty()) {
                if (results.size() > 1) {
                    throw new SQLException("More than one " + FeatureTileLink.class.getSimpleName() + " returned for key. Feature Table Name: " + key.getFeatureTableName() + ", Tile Table Name: " + key.getTileTableName());
                }
                featureTileLink = (FeatureTileLink)results.get(0);
            }
        }
        return featureTileLink;
    }

    public FeatureTileLinkKey extractId(FeatureTileLink data) throws SQLException {
        return data.getId();
    }

    public boolean idExists(FeatureTileLinkKey id) throws SQLException {
        return this.queryForId(id) != null;
    }

    public FeatureTileLink queryForSameId(FeatureTileLink data) throws SQLException {
        return this.queryForId(data.getId());
    }

    public int updateId(FeatureTileLink data, FeatureTileLinkKey newId) throws SQLException {
        int count = 0;
        FeatureTileLink readData = this.queryForId(data.getId());
        if (readData != null && newId != null) {
            readData.setId(newId);
            count = this.update(readData);
        }
        return count;
    }

    public int delete(FeatureTileLink data) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("feature_table_name", (Object)data.getFeatureTableName()).and().eq("tile_table_name", (Object)data.getTileTableName());
        PreparedDelete deleteQuery = db.prepare();
        int deleted = this.delete(deleteQuery);
        return deleted;
    }

    public int deleteById(FeatureTileLinkKey id) throws SQLException {
        FeatureTileLink deleteData;
        int count = 0;
        if (id != null && (deleteData = this.queryForId(id)) != null) {
            count = this.delete(deleteData);
        }
        return count;
    }

    public int deleteIds(Collection<FeatureTileLinkKey> idCollection) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (FeatureTileLinkKey id : idCollection) {
                count += this.deleteById(id);
            }
        }
        return count;
    }

    public int update(FeatureTileLink data) throws SQLException {
        UpdateBuilder ub = this.updateBuilder();
        ub.where().eq("feature_table_name", (Object)data.getFeatureTableName()).and().eq("tile_table_name", (Object)data.getTileTableName());
        PreparedUpdate update = ub.prepare();
        int updated = this.update(update);
        return updated;
    }

    public List<FeatureTileLink> queryForFeatureTableName(String featureTableName) {
        List results = null;
        try {
            results = this.queryForEq("feature_table_name", featureTableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Feature Tile Link objects by Feature Table Name: " + featureTableName);
        }
        return results;
    }

    public List<FeatureTileLink> queryForTileTableName(String tileTableName) {
        List results = null;
        try {
            results = this.queryForEq("tile_table_name", tileTableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Feature Tile Link objects by Tile Table Name: " + tileTableName);
        }
        return results;
    }

    public int deleteByTableName(String tableName) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("feature_table_name", (Object)tableName).or().eq("tile_table_name", (Object)tableName);
        PreparedDelete deleteQuery = db.prepare();
        int deleted = this.delete(deleteQuery);
        return deleted;
    }

    public int deleteAll() throws SQLException {
        int count = 0;
        if (this.isTableExists()) {
            DeleteBuilder db = this.deleteBuilder();
            PreparedDelete deleteQuery = db.prepare();
            count = this.delete(deleteQuery);
        }
        return count;
    }
}

