/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.xml;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.baremaps.openstreetmap.OpenStreetMapFormat;
import org.apache.baremaps.openstreetmap.function.CoordinateMapBuilder;
import org.apache.baremaps.openstreetmap.function.EntityGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.EntityProjectionTransformer;
import org.apache.baremaps.openstreetmap.function.ReferenceMapBuilder;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.stream.ConsumerUtils;
import org.apache.baremaps.openstreetmap.xml.XmlEntitySpliterator;
import org.locationtech.jts.geom.Coordinate;

public class XmlEntityReader
implements OpenStreetMapFormat.EntityReader<Entity> {
    private boolean geometry = false;
    private int srid = 4326;
    private Map<Long, Coordinate> coordinateMap;
    private Map<Long, List<Long>> referenceMap;

    @Override
    public boolean getGeometries() {
        return this.geometry;
    }

    public XmlEntityReader setGeometries(boolean geometries) {
        this.geometry = geometries;
        return this;
    }

    @Override
    public int getSrid() {
        return this.srid;
    }

    public XmlEntityReader setSrid(int srid) {
        this.srid = srid;
        return this;
    }

    @Override
    public Map<Long, Coordinate> getCoordinateMap() {
        return this.coordinateMap;
    }

    public XmlEntityReader setCoordinateMap(Map<Long, Coordinate> coordinateMap) {
        this.coordinateMap = coordinateMap;
        return this;
    }

    @Override
    public Map<Long, List<Long>> getReferenceMap() {
        return this.referenceMap;
    }

    public XmlEntityReader setReferenceMap(Map<Long, List<Long>> referenceMap) {
        this.referenceMap = referenceMap;
        return this;
    }

    @Override
    public Stream<Entity> read(InputStream input) {
        Stream<Entity> entities = StreamSupport.stream(new XmlEntitySpliterator(input), false);
        if (this.geometry) {
            CoordinateMapBuilder coordinateMapBuilder = new CoordinateMapBuilder(this.coordinateMap);
            ReferenceMapBuilder referenceMapBuilder = new ReferenceMapBuilder(this.referenceMap);
            EntityGeometryBuilder entityGeometryBuilder = new EntityGeometryBuilder(this.coordinateMap, this.referenceMap);
            EntityProjectionTransformer entityProjectionTransformer = new EntityProjectionTransformer(4326, this.srid);
            Consumer<Entity> entityHandler = coordinateMapBuilder.andThen(referenceMapBuilder).andThen(entityGeometryBuilder).andThen(entityProjectionTransformer);
            entities = entities.map(ConsumerUtils.consumeThenReturn(entityHandler));
        }
        return entities;
    }
}

