/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.google.errorprone.annotations.MustBeClosed;
import com.linecorp.armeria.common.ContextHolder;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestContextStorage;
import com.linecorp.armeria.common.RequestContextStorageProvider;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.internal.common.LeakTracingRequestContextStorage;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.MapMaker;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestContextUtil {
    private static final Logger logger = LoggerFactory.getLogger(RequestContextUtil.class);
    private static final SafeCloseable noopSafeCloseable = () -> {};
    public static final Supplier<AutoCloseable> NOOP_CONTEXT_HOOK = () -> () -> {};
    private static final Set<Thread> REPORTED_THREADS = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private static RequestContextStorage requestContextStorage;

    public static void init() {
    }

    public static SafeCloseable noopSafeCloseable() {
        return noopSafeCloseable;
    }

    public static IllegalStateException newIllegalContextPushingException(RequestContext newCtx, RequestContext oldCtx) {
        Objects.requireNonNull(newCtx, "newCtx");
        Objects.requireNonNull(oldCtx, "oldCtx");
        IllegalStateException ex = new IllegalStateException("Trying to call object wrapped with context " + newCtx + ", but context is currently set to " + oldCtx + ". This means the callback was called from unexpected thread or forgetting to close previous context.");
        if (REPORTED_THREADS.add(Thread.currentThread())) {
            logger.warn("An error occurred while pushing a context", (Throwable)ex);
        }
        return ex;
    }

    public static IllegalStateException newIllegalContextPoppingException(RequestContext currentCtx, RequestContext contextInStorage) {
        Objects.requireNonNull(currentCtx, "currentCtx");
        Objects.requireNonNull(contextInStorage, "contextInStorage");
        IllegalStateException ex = new IllegalStateException("The currentCtx " + currentCtx + " is not the same as the context in the storage: " + contextInStorage + ". This means the callback was called from unexpected thread or forgetting to close previous context.");
        if (REPORTED_THREADS.add(Thread.currentThread())) {
            logger.warn("An error occurred while popping a context", (Throwable)ex);
        }
        return ex;
    }

    public static void hook(Function<? super RequestContextStorage, ? extends RequestContextStorage> function) {
        RequestContextStorage newStorage = function.apply(requestContextStorage);
        Preconditions.checkState(newStorage != null, "function.apply() returned null: %s", function);
        requestContextStorage = newStorage;
    }

    @Nullable
    public static <T extends RequestContext> T get() {
        return requestContextStorage.currentOrNull();
    }

    @Nullable
    public static <T extends RequestContext> T getAndSet(RequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        return requestContextStorage.push(ctx);
    }

    @MustBeClosed
    public static SafeCloseable pop() {
        Object oldCtx = requestContextStorage.currentOrNull();
        if (oldCtx == null) {
            return RequestContextUtil.noopSafeCloseable();
        }
        RequestContextUtil.pop(oldCtx, null);
        return () -> requestContextStorage.push((RequestContext)oldCtx);
    }

    public static void pop(RequestContext current, @Nullable RequestContext toRestore) {
        Objects.requireNonNull(current, "current");
        requestContextStorage.pop(current, toRestore);
    }

    public static SafeCloseable invokeHookAndPop(RequestContext current, @Nullable RequestContext toRestore) {
        Objects.requireNonNull(current, "current");
        SafeCloseable closeable = RequestContextUtil.invokeHook(current);
        if (closeable == null) {
            return () -> requestContextStorage.pop(current, toRestore);
        }
        return () -> {
            closeable.close();
            requestContextStorage.pop(current, toRestore);
        };
    }

    public static boolean equalsIgnoreWrapper(@Nullable RequestContext ctx1, @Nullable RequestContext ctx2) {
        if (ctx1 == null) {
            return ctx2 == null;
        }
        return ctx1.equalsIgnoreWrapper(ctx2);
    }

    @Nullable
    public static SafeCloseable invokeHook(RequestContext ctx) {
        AutoCloseable closeable;
        Supplier<AutoCloseable> hook = ctx.hook();
        if (hook == NOOP_CONTEXT_HOOK) {
            return null;
        }
        try {
            closeable = hook.get();
        }
        catch (Throwable t) {
            logger.warn("Unexpected exception while executing RequestContext.hook().get(). ctx: {}", (Object)ctx, (Object)t);
            return null;
        }
        if (closeable == null) {
            logger.warn("RequestContext.hook().get() returned null. ctx: {}", (Object)ctx);
            return null;
        }
        return () -> {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                logger.warn("{} Unexpected exception while closing RequestContext.hook().", (Object)ctx, (Object)t);
            }
        };
    }

    public static Supplier<AutoCloseable> mergeHooks(Supplier<? extends AutoCloseable> hook1, Supplier<? extends AutoCloseable> hook2) {
        if (hook1 == NOOP_CONTEXT_HOOK) {
            return hook2;
        }
        if (hook2 == NOOP_CONTEXT_HOOK) {
            return hook1;
        }
        return () -> {
            AutoCloseable closeable1 = (AutoCloseable)hook1.get();
            AutoCloseable closeable2 = (AutoCloseable)hook2.get();
            return () -> {
                try {
                    closeable2.close();
                }
                finally {
                    closeable1.close();
                }
            };
        };
    }

    public static void ensureSameCtx(RequestContext ctx, ContextHolder contextHolder, Class<?> type) {
        if (ctx != contextHolder.context()) {
            throw new IllegalArgumentException("cannot create a " + type.getSimpleName() + " using another " + contextHolder);
        }
    }

    private RequestContextUtil() {
    }

    static {
        RequestContextStorageProvider provider = Flags.requestContextStorageProvider();
        Sampler<? super RequestContext> sampler = Flags.requestContextLeakDetectionSampler();
        try {
            requestContextStorage = sampler == Sampler.never() ? provider.newStorage() : new LeakTracingRequestContextStorage(provider.newStorage(), sampler);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to create context storage. provider: " + provider, t);
        }
    }
}

