/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.util.AsciiString;
import java.util.List;
import java.util.Objects;

public final class ClientAddressSource {
    private static final ClientAddressSource PROXY_PROTOCOL = new ClientAddressSource(HttpHeaderNames.of("PROXY_PROTOCOL"));
    static final List<ClientAddressSource> DEFAULT_SOURCES = ImmutableList.of(ClientAddressSource.ofHeader((CharSequence)HttpHeaderNames.FORWARDED), ClientAddressSource.ofHeader((CharSequence)HttpHeaderNames.X_FORWARDED_FOR), ClientAddressSource.ofProxyProtocol());
    private final AsciiString header;

    public static ClientAddressSource ofHeader(CharSequence header) {
        Preconditions.checkArgument(Objects.requireNonNull(header, "header").length() > 0, "empty header");
        return new ClientAddressSource(HttpHeaderNames.of(header));
    }

    public static ClientAddressSource ofProxyProtocol() {
        return PROXY_PROTOCOL;
    }

    private ClientAddressSource(AsciiString header) {
        this.header = header;
    }

    AsciiString header() {
        return this.header;
    }

    boolean isProxyProtocol() {
        return this.equals(PROXY_PROTOCOL);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientAddressSource)) {
            return false;
        }
        ClientAddressSource that = (ClientAddressSource)o;
        return this.header.equals((Object)that.header);
    }

    public int hashCode() {
        return this.header.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("header", this.header).toString();
    }
}

