/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.composite;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.composite.MergeStrategy;
import org.apache.logging.log4j.core.config.status.StatusConfiguration;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.core.util.Watcher;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.util.Strings;

public class CompositeConfiguration
extends AbstractConfiguration
implements Reconfigurable {
    private final List<? extends AbstractConfiguration> configurations;
    private final MergeStrategy mergeStrategy;

    public CompositeConfiguration(List<? extends AbstractConfiguration> configurations) {
        super(configurations.get(0).getLoggerContext(), ConfigurationSource.COMPOSITE_SOURCE);
        this.rootNode = configurations.get(0).getRootNode();
        this.configurations = configurations;
        this.mergeStrategy = this.getComponent(MergeStrategy.KEY);
        for (AbstractConfiguration abstractConfiguration : configurations) {
            this.mergeStrategy.mergeRootProperties(this.rootNode, abstractConfiguration);
        }
        StatusConfiguration statusConfig = new StatusConfiguration().setStatus(this.getDefaultStatus());
        for (Map.Entry entry : this.rootNode.getAttributes().entrySet()) {
            String key = (String)entry.getKey();
            String value = this.getConfigurationStrSubstitutor().replace((String)entry.getValue());
            if ("status".equalsIgnoreCase(key)) {
                statusConfig.setStatus(Strings.toRootUpperCase((String)value));
                continue;
            }
            if ("dest".equalsIgnoreCase(key)) {
                statusConfig.setDestination(value);
                continue;
            }
            if ("shutdownHook".equalsIgnoreCase(key)) {
                this.isShutdownHookEnabled = !"disable".equalsIgnoreCase(value);
                continue;
            }
            if ("shutdownTimeout".equalsIgnoreCase(key)) {
                this.shutdownTimeoutMillis = Long.parseLong(value);
                continue;
            }
            if ("verbose".equalsIgnoreCase(key)) {
                statusConfig.setVerbosity(value);
                continue;
            }
            if ("packages".equalsIgnoreCase(key)) {
                LOGGER.warn("The packages attribute is no longer supported");
                continue;
            }
            if (!"name".equalsIgnoreCase(key)) continue;
            this.setName(value);
        }
        statusConfig.initialize();
    }

    @Override
    public void setup() {
        AbstractConfiguration targetConfiguration = this.configurations.get(0);
        this.staffChildConfiguration(targetConfiguration);
        WatchManager watchManager = this.getWatchManager();
        WatchManager targetWatchManager = targetConfiguration.getWatchManager();
        if (targetWatchManager.getIntervalSeconds() > 0) {
            watchManager.setIntervalSeconds(targetWatchManager.getIntervalSeconds());
            Map<Source, Watcher> watchers = targetWatchManager.getConfigurationWatchers();
            for (Map.Entry<Source, Watcher> entry : watchers.entrySet()) {
                watchManager.watch(entry.getKey(), entry.getValue().newWatcher(this, this.listeners, entry.getValue().getLastModified()));
            }
        }
        for (AbstractConfiguration abstractConfiguration : this.configurations.subList(1, this.configurations.size())) {
            int monitorInterval;
            this.staffChildConfiguration(abstractConfiguration);
            Node sourceRoot = abstractConfiguration.getRootNode();
            this.mergeStrategy.mergeConfigurations(this.rootNode, sourceRoot, this.corePlugins);
            if (LOGGER.isEnabled(Level.ALL)) {
                StringBuilder sb = new StringBuilder();
                this.printNodes("", this.rootNode, sb);
                System.out.println(sb.toString());
            }
            if ((monitorInterval = abstractConfiguration.getWatchManager().getIntervalSeconds()) <= 0) continue;
            int currentInterval = watchManager.getIntervalSeconds();
            if (currentInterval <= 0 || monitorInterval < currentInterval) {
                watchManager.setIntervalSeconds(monitorInterval);
            }
            WatchManager sourceWatchManager = abstractConfiguration.getWatchManager();
            Map<Source, Watcher> watchers = sourceWatchManager.getConfigurationWatchers();
            for (Map.Entry<Source, Watcher> entry : watchers.entrySet()) {
                watchManager.watch(entry.getKey(), entry.getValue().newWatcher(this, this.listeners, entry.getValue().getLastModified()));
            }
        }
    }

    @Override
    public Configuration reconfigure() {
        LOGGER.debug("Reconfiguring composite configuration");
        ArrayList<AbstractConfiguration> configs = new ArrayList<AbstractConfiguration>();
        ConfigurationFactory factory = (ConfigurationFactory)this.instanceFactory.getInstance(ConfigurationFactory.KEY);
        for (AbstractConfiguration abstractConfiguration : this.configurations) {
            ConfigurationSource source = abstractConfiguration.getConfigurationSource();
            URI sourceURI = source.getURI();
            Configuration currentConfig = abstractConfiguration;
            if (sourceURI == null) {
                LOGGER.warn("Unable to determine URI for configuration {}, changes to it will be ignored", (Object)abstractConfiguration.getName());
            } else {
                currentConfig = factory.getConfiguration(this.getLoggerContext(), abstractConfiguration.getName(), sourceURI);
                if (currentConfig == null) {
                    LOGGER.warn("Unable to reload configuration {}, changes to it will be ignored", (Object)abstractConfiguration.getName());
                }
            }
            configs.add((AbstractConfiguration)currentConfig);
        }
        return new CompositeConfiguration(configs);
    }

    private void staffChildConfiguration(AbstractConfiguration childConfiguration) {
        childConfiguration.setCorePlugins(this.corePlugins);
        childConfiguration.setScriptManager(this.scriptManager);
        childConfiguration.setup();
    }

    private void printNodes(String indent, Node node, StringBuilder sb) {
        sb.append(indent).append(node.getName()).append(" type: ").append(node.getType()).append("\n");
        sb.append(indent).append(node.getAttributes().toString()).append("\n");
        for (Node child : node.getChildren()) {
            this.printNodes(indent + "  ", child, sb);
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + " [configurations=" + this.configurations + ", mergeStrategy=" + this.mergeStrategy + ", rootNode=" + this.rootNode + ", listeners=" + this.listeners + ", corePlugins=" + this.corePlugins + ", isShutdownHookEnabled=" + this.isShutdownHookEnabled + ", shutdownTimeoutMillis=" + this.shutdownTimeoutMillis + ", scriptManager=" + this.scriptManager + "]";
    }
}

