/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Map;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;

public interface ThreadContextMap {
    public void clear();

    public boolean containsKey(String var1);

    public String get(String var1);

    public Map<String, String> getCopy();

    public Map<String, String> getImmutableMapOrNull();

    public boolean isEmpty();

    public void put(String var1, String var2);

    public void remove(String var1);

    default public void putAll(Map<String, String> map) {
        map.forEach(this::put);
    }

    default public StringMap getReadOnlyContextData() {
        if (this instanceof ReadOnlyThreadContextMap) {
            return ((ReadOnlyThreadContextMap)((Object)this)).getReadOnlyContextData();
        }
        Map<String, String> copy = this.getCopy();
        SortedArrayStringMap map = new SortedArrayStringMap(copy.size());
        copy.forEach(map::putValue);
        map.freeze();
        return map;
    }

    default public void removeAll(Iterable<String> keys) {
        keys.forEach(this::remove);
    }

    default public <V> V getValue(String key) {
        return (V)Cast.cast(this.get(key));
    }

    default public <V> void putValue(String key, V value) {
        this.put(key, value != null ? value.toString() : null);
    }

    default public <V> void putAllValues(Map<String, V> values) {
        values.forEach(this::putValue);
    }
}

