/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.dem;

public class HillshadeCalculator {
    private static final double EARTH_RADIUS = 6378137.0;
    private static final int TILE_SIZE = 256;
    private double[] dem;
    private int width;
    private int height;
    private double cellSize;
    private double[] hillshade;

    public HillshadeCalculator(double[] dem, int width, int height, double cellSize) {
        this.dem = dem;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.hillshade = new double[width * height];
    }

    private static void validateInput(double[] grid, int width, int height, double altitude, double azimuth) {
        if (grid == null || grid.length == 0) {
            throw new IllegalArgumentException("Grid array cannot be null or empty");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be positive");
        }
        if (grid.length != width * height) {
            throw new IllegalArgumentException("Grid array length does not match width * height");
        }
        if (altitude < 0.0 || altitude > 90.0) {
            throw new IllegalArgumentException("Altitude must be between 0 and 90 degrees");
        }
        if (azimuth < 0.0 || azimuth > 360.0) {
            throw new IllegalArgumentException("Azimuth must be between 0 and 360 degrees");
        }
    }

    public double[] calculate(double altitude, double azimuth) {
        HillshadeCalculator.validateInput(this.dem, this.width, this.height, altitude, azimuth);
        double azimuthDeg = 360.0 - azimuth + 90.0;
        double azimuthRad = Math.toRadians(azimuthDeg);
        double zenithDeg = 90.0 - altitude;
        double zenithRad = Math.toRadians(zenithDeg);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                double a = this.getElevation(x - 1, y - 1);
                double b = this.getElevation(x, y - 1);
                double c = this.getElevation(x + 1, y - 1);
                double d = this.getElevation(x - 1, y);
                double f = this.getElevation(x + 1, y);
                double g = this.getElevation(x - 1, y + 1);
                double h = this.getElevation(x, y + 1);
                double i = this.getElevation(x + 1, y + 1);
                double dzdx = (c + 2.0 * f + i - (a + 2.0 * d + g)) / (8.0 * this.cellSize);
                double dzdy = (g + 2.0 * h + i - (a + 2.0 * b + c)) / (8.0 * this.cellSize);
                double slopeRad = Math.atan(Math.sqrt(dzdx * dzdx + dzdy * dzdy));
                double aspectRad = Math.atan2(dzdy, -dzdx);
                if (aspectRad < 0.0) {
                    aspectRad += Math.PI * 2;
                }
                double hillshadeValue = 255.0 * (Math.cos(zenithRad) * Math.cos(slopeRad) + Math.sin(zenithRad) * Math.sin(slopeRad) * Math.cos(azimuthRad - aspectRad));
                this.hillshade[y * this.width + x] = hillshadeValue = Math.max(0.0, Math.min(255.0, hillshadeValue));
            }
        }
        return this.hillshade;
    }

    public double getElevation(int x, int y) {
        x = Math.max(0, Math.min(this.width - 1, x));
        y = Math.max(0, Math.min(this.height - 1, y));
        return this.dem[y * this.width + x];
    }

    public static double getResolution(int zoomLevel) {
        return 4.007501668557849E7 / (256.0 * Math.pow(2.0, zoomLevel));
    }
}

