/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.util;

import de.bytefish.pgbulkinsert.exceptions.PgConnectionException;
import de.bytefish.pgbulkinsert.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import org.postgresql.PGConnection;
import org.postgresql.core.Utils;

public final class PostgreSqlUtils {
    private PostgreSqlUtils() {
    }

    public static PGConnection getPGConnection(Connection connection) {
        return PostgreSqlUtils.tryGetPGConnection(connection).orElseThrow(() -> new PgConnectionException("Could not obtain a PGConnection"));
    }

    public static Optional<PGConnection> tryGetPGConnection(Connection connection) {
        Optional<PGConnection> fromCast = PostgreSqlUtils.tryCastConnection(connection);
        if (fromCast.isPresent()) {
            return fromCast;
        }
        return PostgreSqlUtils.tryUnwrapConnection(connection);
    }

    private static Optional<PGConnection> tryCastConnection(Connection connection) {
        if (connection instanceof PGConnection) {
            return Optional.of((PGConnection)connection);
        }
        return Optional.empty();
    }

    private static Optional<PGConnection> tryUnwrapConnection(Connection connection) {
        try {
            if (connection.isWrapperFor(PGConnection.class)) {
                return Optional.of(connection.unwrap(PGConnection.class));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static String quoteIdentifier(String identifier) {
        try {
            return Utils.escapeIdentifier(null, (String)identifier).toString();
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Invalid identifier", e);
        }
    }

    public static String getFullyQualifiedTableName(String schemaName, String tableName, boolean usePostgresQuoting) {
        if (usePostgresQuoting) {
            return StringUtils.isNullOrWhiteSpace(schemaName) ? PostgreSqlUtils.quoteIdentifier(tableName) : String.format("%s.%s", PostgreSqlUtils.quoteIdentifier(schemaName), PostgreSqlUtils.quoteIdentifier(tableName));
        }
        if (StringUtils.isNullOrWhiteSpace(schemaName)) {
            return tableName;
        }
        return String.format("%1$s.%2$s", schemaName, tableName);
    }
}

