/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.util.resources.Errors;

final class ReversedBitsChannel
implements ReadableByteChannel,
SeekableByteChannel {
    private static final byte[] REVERSE = new byte[256];
    private final ChannelDataInput input;

    private ReversedBitsChannel(ChannelDataInput input) {
        this.input = input;
    }

    static ChannelDataInput wrap(ChannelDataInput input) throws IOException {
        ChannelDataInput output = new ChannelDataInput(input.filename, (ReadableByteChannel)new ReversedBitsChannel(input), ByteBuffer.allocate(2048).order(input.buffer.order()).limit(0), true);
        output.setStreamPosition(input.getStreamPosition());
        return output;
    }

    @Override
    public long size() throws IOException {
        if (this.input.channel instanceof SeekableByteChannel) {
            return ((SeekableByteChannel)this.input.channel).size();
        }
        throw ReversedBitsChannel.unsupported("size");
    }

    @Override
    public long position() {
        return this.input.getStreamPosition();
    }

    @Override
    public SeekableByteChannel position(long p) throws IOException {
        this.input.setStreamPosition(p);
        return this;
    }

    @Override
    public int read(ByteBuffer target) throws IOException {
        int n = target.remaining();
        if (n != 0) {
            ByteBuffer source = this.input.buffer;
            if (!source.hasRemaining()) {
                this.input.ensureBufferContains(1);
            }
            int r = n = Math.min(n, source.remaining());
            while (--r >= 0) {
                target.put(REVERSE[Byte.toUnsignedInt(source.get())]);
            }
        }
        return n;
    }

    @Override
    public int write(ByteBuffer source) throws IOException {
        throw ReversedBitsChannel.unsupported("write");
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw ReversedBitsChannel.unsupported("truncate");
    }

    private static IOException unsupported(String operation) {
        return new IOException(Errors.format((short)162, (Object)operation));
    }

    @Override
    public final boolean isOpen() {
        return this.input.channel.isOpen();
    }

    @Override
    public final void close() {
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ReversedBitsChannel.REVERSE[i] = (byte)(Integer.reverse(i) >>> 24);
        }
    }
}

