/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSLogicalNode;
import com.oracle.truffle.js.nodes.binary.JSNullishCoalescingNodeGen;
import com.oracle.truffle.js.nodes.unary.JSIsNullOrUndefinedNode;
import java.util.Set;

@NodeInfo(shortName="??")
public abstract class JSNullishCoalescingNode
extends JSLogicalNode {
    JSNullishCoalescingNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        return JSNullishCoalescingNodeGen.create(left, right);
    }

    @Specialization
    protected Object doGeneric(VirtualFrame frame, Object leftValue, @Cached JSIsNullOrUndefinedNode isNullOrUndefinedNode, @Cached InlinedConditionProfile canShortCircuit) {
        if (canShortCircuit.profile((Node)this, !isNullOrUndefinedNode.executeBoolean(leftValue))) {
            return leftValue;
        }
        return this.rightNode.execute(frame);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSNullishCoalescingNode.create(JSNullishCoalescingNode.cloneUninitialized(this.getLeft(), materializedTags), JSNullishCoalescingNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

