/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataRowImpl;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataStoreException;
import org.apache.baremaps.store.DataTable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

public class PostgresDataTable
implements DataTable {
    private final DataSource dataSource;
    private final DataSchema schema;

    public PostgresDataTable(DataSource dataSource, DataSchema schema) {
        this.dataSource = dataSource;
        this.schema = schema;
    }

    public PostgresIterator iterator() {
        return new PostgresIterator();
    }

    public Stream<DataRow> stream() {
        PostgresIterator iterator = this.iterator();
        Spliterator<DataRow> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        Stream<DataRow> stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(iterator::close);
    }

    /*
     * Exception decompiling
     */
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DataSchema schema() {
        return this.schema;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean add(DataRow row) {
        String query = PostgresDataTable.insert(this.schema);
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(query);
                try {
                    this.setParameters(statement, row);
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean addAll(Iterable<DataRow> rows) {
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement statement = connection.prepareStatement(PostgresDataTable.insert(this.schema));
                try {
                    for (DataRow row : rows) {
                        this.setParameters(statement, row);
                        statement.addBatch();
                    }
                    statement.executeBatch();
                    bl = true;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    public void clear() {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(this.truncate(this.schema));
        }
        catch (SQLException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    private void setParameters(PreparedStatement statement, DataRow row) throws SQLException {
        for (int i = 1; i <= this.schema.columns().size(); ++i) {
            Object value = row.get(((DataColumn)this.schema.columns().get(i - 1)).name());
            if (value instanceof Geometry) {
                Geometry geometry = (Geometry)value;
                statement.setBytes(i, PostgresDataTable.serialize(geometry));
                continue;
            }
            statement.setObject(i, value);
        }
    }

    private static byte[] serialize(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        WKBWriter writer = new WKBWriter(2, 1, true);
        return writer.write(geometry);
    }

    private static Geometry deserialize(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        try {
            WKBReader reader = new WKBReader(new GeometryFactory());
            return reader.read(wkb);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected static String select(DataSchema schema) {
        List<String> columns = schema.columns().stream().map(column -> {
            if (column.type().binding().isAssignableFrom(Geometry.class)) {
                return String.format("st_asewkb(\"%s\") AS \"%s\"", column.name(), column.name());
            }
            return String.format("\"%s\"", column.name());
        }).toList();
        return "SELECT " + String.join((CharSequence)", ", columns) + " FROM \"" + schema.name() + "\"";
    }

    protected static String insert(DataSchema schema) {
        List<String> columns = schema.columns().stream().map(column -> String.format("\"%s\"", column.name())).toList();
        List<String> values = schema.columns().stream().map(column -> "?").toList();
        return "INSERT INTO \"" + schema.name() + "\" (" + String.join((CharSequence)", ", columns) + ") VALUES (" + String.join((CharSequence)", ", values) + ")";
    }

    protected String count(DataSchema schema) {
        return String.format("SELECT COUNT(*) FROM \"%s\"", schema.name());
    }

    private String truncate(DataSchema schema) {
        return String.format("TRUNCATE TABLE \"%s\"", schema.name());
    }

    public class PostgresIterator
    implements Iterator<DataRow>,
    AutoCloseable {
        private Connection connection;
        private Statement statement;
        private ResultSet resultSet;
        private boolean hasNext;

        public PostgresIterator() {
            try {
                this.connection = PostgresDataTable.this.dataSource.getConnection();
                this.statement = this.connection.createStatement();
                this.resultSet = this.statement.executeQuery(PostgresDataTable.select(PostgresDataTable.this.schema));
                this.hasNext = this.resultSet.next();
            }
            catch (SQLException e) {
                this.close();
                throw new DataStoreException("Error while initializing SQL query iterator", (Throwable)e);
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNext) {
                this.close();
            }
            return this.hasNext;
        }

        @Override
        public DataRow next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            try {
                ArrayList<Object> values = new ArrayList<Object>();
                for (int i = 0; i < PostgresDataTable.this.schema.columns().size(); ++i) {
                    DataColumn column = (DataColumn)PostgresDataTable.this.schema.columns().get(i);
                    if (column.type().binding().isAssignableFrom(Geometry.class)) {
                        values.add(PostgresDataTable.deserialize(this.resultSet.getBytes(i + 1)));
                        continue;
                    }
                    values.add(this.resultSet.getObject(i + 1));
                }
                this.hasNext = this.resultSet.next();
                return new DataRowImpl(PostgresDataTable.this.schema, values);
            }
            catch (SQLException e) {
                this.close();
                throw new DataStoreException("Error while fetching the next result", (Throwable)e);
            }
        }

        @Override
        public void close() {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                throw new DataStoreException("Error while closing resources", (Throwable)e);
            }
        }
    }
}

