/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.calcite;

import org.apache.baremaps.data.calcite.SqlTypeConversion;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataTable;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.impl.AbstractTable;

public class SqlDataTable
extends AbstractTable
implements ScannableTable {
    private final DataTable table;
    private RelDataType rowType;

    public SqlDataTable(DataTable table) {
        this.table = table;
    }

    public Enumerable<Object[]> scan(DataContext root) {
        return Linq4j.asEnumerable(() -> this.table.stream().map(row -> row.values().toArray()).iterator());
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.rowType == null) {
            this.rowType = this.createRowType(typeFactory);
        }
        return this.rowType;
    }

    private RelDataType createRowType(RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.Builder rowTypeBuilder = new RelDataTypeFactory.Builder(typeFactory);
        for (DataColumn column : this.table.schema().columns()) {
            rowTypeBuilder.add(column.name(), SqlTypeConversion.types.get(column.type()));
        }
        return rowTypeBuilder.build();
    }
}

