/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.data.type.DataType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

public class WKBDataType
implements DataType<Geometry> {
    public static final GeometryFactory GEOMETRY_FACTORY_WGS84 = new GeometryFactory(new PrecisionModel(), 4326);

    @Override
    public int size(Geometry value) {
        byte[] bytes = WKBDataType.serialize(value);
        if (bytes == null) {
            return 4;
        }
        return 4 + bytes.length;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, Geometry value) {
        byte[] bytes = WKBDataType.serialize(value);
        if (bytes == null) {
            buffer.putInt(position, 4);
        } else {
            buffer.putInt(position, 4 + bytes.length);
            buffer.put(position + 4, bytes);
        }
    }

    @Override
    public Geometry read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        byte[] bytes = new byte[Math.max(size - 4, 0)];
        buffer.get(position + 4, bytes);
        return WKBDataType.deserialize(bytes);
    }

    private static byte[] serialize(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        WKBWriter writer = new WKBWriter(2, 1, true);
        return writer.write(geometry);
    }

    private static Geometry deserialize(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        try {
            WKBReader reader = new WKBReader(new GeometryFactory());
            return reader.read(wkb);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

