/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoder.geonames;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.baremaps.geocoder.geonames.GeonamesEntry;

public class GeonamesReader {
    public Stream<GeonamesEntry> stream(InputStream inputStream) throws IOException {
        CsvMapper mapper = new CsvMapper();
        CsvSchema schema = CsvSchema.builder().addColumn("geonameid").addColumn("name").addColumn("asciiname").addColumn("alternatenames").addColumn("latitude").addColumn("longitude").addColumn("featureClass").addColumn("featureCode").addColumn("countryCode").addColumn("cc2").addColumn("admin1Code").addColumn("admin2Code").addColumn("admin3Code").addColumn("admin4Code").addColumn("population").addColumn("elevation").addColumn("dem").addColumn("timezone").addColumn("modificationDate").build().withColumnSeparator('\t').withoutQuoteChar();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        MappingIterator recordIterator = mapper.readerFor(GeonamesEntry.class).with((FormatSchema)schema).readValues((Reader)reader);
        Spliterator recordSpliterator = Spliterators.spliteratorUnknownSize(recordIterator, 0);
        return StreamSupport.stream(recordSpliterator, false);
    }
}

