/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.raster;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.baremaps.dem.ContourTracer;
import org.apache.baremaps.dem.ElevationUtils;
import org.apache.baremaps.dem.HillshadeCalculator;
import org.apache.baremaps.maplibre.binary.VectorTile;
import org.apache.baremaps.maplibre.vectortile.Feature;
import org.apache.baremaps.maplibre.vectortile.Layer;
import org.apache.baremaps.maplibre.vectortile.Tile;
import org.apache.baremaps.maplibre.vectortile.VectorTileEncoder;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.apache.baremaps.tilestore.raster.GeoTiffReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.AffineTransformation;

public class VectorHillshadeTileStore
implements TileStore<ByteBuffer> {
    private final GeoTiffReader geoTiffReader;

    public VectorHillshadeTileStore(GeoTiffReader geoTiffReader) {
        this.geoTiffReader = geoTiffReader;
    }

    @Override
    public ByteBuffer read(TileCoord tileCoord) throws TileStoreException {
        ByteBuffer byteBuffer;
        int size = 256;
        ArrayList<Feature> features = new ArrayList<Feature>();
        double[] grid = this.geoTiffReader.read(tileCoord, size, 16);
        grid = ElevationUtils.clampGrid((double[])grid, (double)0.0, (double)10000.0);
        grid = new HillshadeCalculator(grid, size + 32, size + 32, HillshadeCalculator.getResolution((int)tileCoord.z()) / 2.0).calculate(45.0, 315.0);
        VectorHillshadeTileStore.contours(grid, 239, features, 1);
        VectorHillshadeTileStore.contours(grid, 223, features, 2);
        grid = ElevationUtils.invertGrid((double[])grid);
        VectorHillshadeTileStore.contours(grid, 223, features, 6);
        VectorHillshadeTileStore.contours(grid, 191, features, 5);
        VectorHillshadeTileStore.contours(grid, 157, features, 4);
        VectorHillshadeTileStore.contours(grid, 127, features, 3);
        Layer layer = new Layer("elevation", 4096, features);
        Tile tile = new Tile(List.of(layer));
        VectorTile.Tile vectorTile = new VectorTileEncoder().encodeTile(tile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(baos);
            vectorTile.writeTo((OutputStream)gzip);
            gzip.close();
            byteBuffer = ByteBuffer.wrap(baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new TileStoreException(e);
            }
        }
        baos.close();
        return byteBuffer;
    }

    private static void contours(double[] grid, int level, ArrayList<Feature> features, int category) {
        List contours = new ContourTracer(grid, (int)Math.sqrt(grid.length), (int)Math.sqrt(grid.length), false, true).traceContours((double)level);
        for (Geometry contour : contours) {
            contour = AffineTransformation.translationInstance((double)-16.0, (double)-16.0).scale(16.0, 16.0).transform(contour);
            features.add(new Feature((long)category, Map.of("level", String.valueOf(category)), contour));
        }
    }

    @Override
    public void write(TileCoord tileCoord, ByteBuffer blob) throws TileStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(TileCoord tileCoord) throws TileStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
    }
}

