/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import javax.measure.UnitConverter;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;

final class IdentityConverter
extends AbstractConverter
implements LenientComparable {
    private static final long serialVersionUID = 1230536100139464866L;
    static final IdentityConverter INSTANCE = new IdentityConverter();

    private IdentityConverter() {
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    public UnitConverter inverse() {
        return this;
    }

    public double convert(double value) {
        return value;
    }

    @Override
    public double derivative(double value) {
        return 1.0;
    }

    @Override
    public UnitConverter concatenate(UnitConverter c) {
        return c;
    }

    public String toString() {
        return "y\u00a0=\u00a0x";
    }

    @Override
    public Number convert(Number value) {
        ArgumentChecks.ensureNonNull("value", value);
        return value;
    }

    public int hashCode() {
        return 1008433314;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof AbstractConverter && ((AbstractConverter)other).isIdentity();
    }

    @Override
    public boolean equals(Object other, ComparisonMode mode) {
        if (mode.isApproximate() && other instanceof LinearConverter) {
            return ((LinearConverter)other).almostIdentity();
        }
        return other instanceof UnitConverter && ((UnitConverter)other).isIdentity();
    }
}

