/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.kadmin.remote.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminHandler;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.AdminRequest;
import org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.xnio.sasl.SaslWrapper;

public class DefaultAdminHandler
extends AdminHandler {
    @Override
    public void handleRequest(AdminRequest adminRequest, SaslWrapper sasl) throws KrbException {
        super.handleRequest(adminRequest, sasl);
        KrbTransport transport = adminRequest.getTransport();
        try {
            ByteBuffer receiveMessage = transport.receiveMessage();
            ByteBuffer unwrapMessage = ByteBuffer.wrap(sasl.unwrap(receiveMessage));
            super.onResponseMessage(adminRequest, unwrapMessage);
        }
        catch (IOException e) {
            throw new KrbException("Admin receives response message failed", (Throwable)e);
        }
    }

    @Override
    protected void sendMessage(AdminRequest adminRequest, ByteBuffer requestMessage) throws IOException {
        KrbTransport transport = adminRequest.getTransport();
        transport.sendMessage(requestMessage);
    }

    @Override
    public List<String> handleRequestForList(AdminRequest adminRequest, SaslWrapper sasl) throws KrbException {
        List<String> prinicalList;
        super.handleRequest(adminRequest, sasl);
        KrbTransport transport = adminRequest.getTransport();
        try {
            ByteBuffer receiveMessage = transport.receiveMessage();
            ByteBuffer unwrapMessage = ByteBuffer.wrap(sasl.unwrap(receiveMessage));
            prinicalList = super.onResponseMessageForList(adminRequest, unwrapMessage);
        }
        catch (IOException e) {
            throw new KrbException("Admin receives response message failed", (Throwable)e);
        }
        return prinicalList;
    }

    @Override
    protected byte[] handleRequestForBytes(AdminRequest adminRequest, SaslWrapper sasl) throws KrbException {
        byte[] keytabFileBytes;
        super.handleRequest(adminRequest, sasl);
        KrbTransport transport = adminRequest.getTransport();
        try {
            ByteBuffer receiveMessage = transport.receiveMessage();
            ByteBuffer unwrapMessage = ByteBuffer.wrap(sasl.unwrap(receiveMessage));
            keytabFileBytes = super.onResponseMessageForBytesArray(adminRequest, unwrapMessage);
        }
        catch (IOException e) {
            throw new KrbException("Admin receives response message failed", (Throwable)e);
        }
        return keytabFileBytes;
    }

    @Override
    protected KrbIdentity handleRequestForIdentity(AdminRequest adminRequest, SaslWrapper sasl) throws KrbException {
        KrbIdentity identity;
        super.handleRequest(adminRequest, sasl);
        KrbTransport transport = adminRequest.getTransport();
        try {
            ByteBuffer receiveMessage = transport.receiveMessage();
            ByteBuffer unwrapMessage = ByteBuffer.wrap(sasl.unwrap(receiveMessage));
            identity = super.onResponseMessageForIdentity(adminRequest, unwrapMessage);
        }
        catch (IOException e) {
            throw new KrbException("Admin receives response message failed", (Throwable)e);
        }
        return identity;
    }
}

