/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hadoop.fs;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemProvider;
import org.apache.gravitino.catalog.hadoop.fs.GravitinoFileSystemCredentialsProvider;
import org.apache.hadoop.conf.Configuration;

public class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static Map<String, FileSystemProvider> getFileSystemProviders(String fileSystemProviders) {
        HashMap resultMap = Maps.newHashMap();
        ServiceLoader<FileSystemProvider> allFileSystemProviders = ServiceLoader.load(FileSystemProvider.class);
        HashSet providersInUses = fileSystemProviders != null ? Arrays.stream(fileSystemProviders.split(",")).map(f -> f.trim().toLowerCase(Locale.ROOT)).collect(Collectors.toSet()) : Sets.newHashSet();
        providersInUses.add("builtin-local".toLowerCase(Locale.ROOT));
        providersInUses.add("builtin-hdfs".toLowerCase(Locale.ROOT));
        Streams.stream(allFileSystemProviders.iterator()).filter(fileSystemProvider -> providersInUses.contains(fileSystemProvider.name().toLowerCase(Locale.ROOT))).forEach(fileSystemProvider -> {
            if (resultMap.containsKey(fileSystemProvider.scheme())) {
                throw new UnsupportedOperationException(String.format("File system provider: '%s' with scheme '%s' already exists in the provider list,please make sure the file system provider scheme is unique.", fileSystemProvider.getClass().getName(), fileSystemProvider.scheme()));
            }
            resultMap.put(fileSystemProvider.scheme(), fileSystemProvider);
        });
        ImmutableSet notFoundProviders = Sets.difference((Set)providersInUses, resultMap.values().stream().map(p -> p.name().toLowerCase(Locale.ROOT)).collect(Collectors.toSet())).immutableCopy();
        if (!notFoundProviders.isEmpty()) {
            throw new UnsupportedOperationException(String.format("File system providers %s not found in the classpath. Please make sure the file system provider is in the classpath.", notFoundProviders));
        }
        return resultMap;
    }

    public static FileSystemProvider getFileSystemProviderByName(Map<String, FileSystemProvider> fileSystemProviders, String fileSystemProviderName) {
        return fileSystemProviders.entrySet().stream().filter(entry -> ((FileSystemProvider)entry.getValue()).name().equals(fileSystemProviderName)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new UnsupportedOperationException(String.format("File system provider with name '%s' not found in the file system provider list.", fileSystemProviderName)));
    }

    public static Map<String, String> toHadoopConfigMap(Map<String, String> config, Map<String, String> predefinedKeys) {
        HashMap result = Maps.newHashMap();
        config.forEach((k, v) -> {
            if (k.startsWith("gravitino.bypass.")) {
                String key = k.replace("gravitino.bypass.", "");
                result.put(key, v);
            }
        });
        config.forEach((k, v) -> {
            if (!predefinedKeys.containsKey(k) && !k.startsWith("gravitino.bypass.")) {
                result.put(k, v);
            }
        });
        config.forEach((k, v) -> {
            if (predefinedKeys.containsKey(k)) {
                String key = (String)predefinedKeys.get(k);
                result.put(key, v);
            }
        });
        return result;
    }

    public static GravitinoFileSystemCredentialsProvider getGvfsCredentialProvider(Configuration conf) {
        try {
            GravitinoFileSystemCredentialsProvider gravitinoFileSystemCredentialsProvider = (GravitinoFileSystemCredentialsProvider)Class.forName(conf.get("fs.gvfs.credential.provider")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            gravitinoFileSystemCredentialsProvider.setConf(conf);
            return gravitinoFileSystemCredentialsProvider;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create GravitinoFileSystemCredentialProvider", e);
        }
    }
}

