/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.expressions.literals;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.types.Decimal;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;

public class Literals {
    public static final Literal<Types.NullType> NULL = new LiteralImpl<Types.NullType>(null, Types.NullType.get());

    public static <T> LiteralImpl<T> of(T value, Type dataType) {
        return new LiteralImpl(value, dataType);
    }

    public static LiteralImpl<Boolean> booleanLiteral(Boolean value) {
        return Literals.of(value, Types.BooleanType.get());
    }

    public static LiteralImpl<Byte> byteLiteral(Byte value) {
        return Literals.of(value, Types.ByteType.get());
    }

    public static LiteralImpl<Short> unsignedByteLiteral(Short value) {
        return Literals.of(value, Types.ByteType.unsigned());
    }

    public static LiteralImpl<Short> shortLiteral(Short value) {
        return Literals.of(value, Types.ShortType.get());
    }

    public static LiteralImpl<Integer> unsignedShortLiteral(Integer value) {
        return Literals.of(value, Types.ShortType.unsigned());
    }

    public static LiteralImpl<Integer> integerLiteral(Integer value) {
        return Literals.of(value, Types.IntegerType.get());
    }

    public static LiteralImpl<Long> unsignedIntegerLiteral(Long value) {
        return Literals.of(value, Types.IntegerType.unsigned());
    }

    public static LiteralImpl<Long> longLiteral(Long value) {
        return Literals.of(value, Types.LongType.get());
    }

    public static LiteralImpl<Decimal> unsignedLongLiteral(Decimal value) {
        return Literals.of(value, Types.LongType.unsigned());
    }

    public static LiteralImpl<Float> floatLiteral(Float value) {
        return Literals.of(value, Types.FloatType.get());
    }

    public static LiteralImpl<Double> doubleLiteral(Double value) {
        return Literals.of(value, Types.DoubleType.get());
    }

    public static LiteralImpl<Decimal> decimalLiteral(Decimal value) {
        return Literals.of(value, Types.DecimalType.of(value.precision(), value.scale()));
    }

    public static LiteralImpl<LocalDate> dateLiteral(LocalDate value) {
        return Literals.of(value, Types.DateType.get());
    }

    public static LiteralImpl<LocalTime> timeLiteral(LocalTime value) {
        return Literals.of(value, Types.TimeType.get());
    }

    public static LiteralImpl<LocalDateTime> timestampLiteral(LocalDateTime value) {
        return Literals.of(value, Types.TimestampType.withoutTimeZone());
    }

    public static LiteralImpl<LocalDateTime> timestampLiteral(String value) {
        return Literals.timestampLiteral(LocalDateTime.parse(value));
    }

    public static LiteralImpl<String> stringLiteral(String value) {
        return Literals.of(value, Types.StringType.get());
    }

    public static LiteralImpl<String> varcharLiteral(int length, String value) {
        return Literals.of(value, Types.VarCharType.of(length));
    }

    private Literals() {
    }

    public static final class LiteralImpl<T>
    implements Literal<T> {
        private final T value;
        private final Type dataType;

        private LiteralImpl(T value, Type dataType) {
            this.value = value;
            this.dataType = dataType;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public Type dataType() {
            return this.dataType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LiteralImpl literal = (LiteralImpl)o;
            if (!Objects.equals(this.dataType, literal.dataType)) {
                return false;
            }
            if (this.value == null || literal.value == null) {
                return Objects.equals(this.value, literal.value);
            }
            return Objects.equals(this.value, literal.value) || this.value.toString().equals(literal.value.toString());
        }

        public int hashCode() {
            return Objects.hash(this.dataType, this.value != null ? this.value.toString() : null);
        }

        public String toString() {
            return "LiteralImpl{value=" + this.value + ", dataType=" + this.dataType + '}';
        }
    }
}

