/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.NativeJpaQuery;
import org.springframework.data.jpa.repository.query.SimpleJpaQuery;
import org.springframework.data.jpa.repository.query.StoredProcedureJpaQuery;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.lang.Nullable;

enum JpaQueryFactory {
    INSTANCE;


    AbstractJpaQuery fromMethodWithQueryString(JpaQueryMethod method, EntityManager em, String queryString, @Nullable String countQueryString, QueryRewriter queryRewriter, ValueExpressionDelegate valueExpressionDelegate) {
        if (method.isScrollQuery()) {
            throw QueryCreationException.create((QueryMethod)method, (String)"Scroll queries are not supported using String-based queries");
        }
        return method.isNativeQuery() ? new NativeJpaQuery(method, em, queryString, countQueryString, queryRewriter, valueExpressionDelegate) : new SimpleJpaQuery(method, em, queryString, countQueryString, queryRewriter, valueExpressionDelegate);
    }

    public StoredProcedureJpaQuery fromProcedureAnnotation(JpaQueryMethod method, EntityManager em) {
        if (method.isScrollQuery()) {
            throw QueryCreationException.create((QueryMethod)method, (String)"Scroll queries are not supported using stored procedures");
        }
        return new StoredProcedureJpaQuery(method, em);
    }
}

