/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket;

import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.Netty5DataBuffer;
import org.springframework.core.io.buffer.Netty5DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class WebSocketMessage {
    private static final boolean reactorNetty2Present = ClassUtils.isPresent((String)"io.netty5.handler.codec.http.websocketx.WebSocketFrame", (ClassLoader)WebSocketMessage.class.getClassLoader());
    private final Type type;
    private final DataBuffer payload;
    @Nullable
    private final Object nativeMessage;

    public WebSocketMessage(Type type, DataBuffer payload) {
        this(type, payload, null);
    }

    public WebSocketMessage(Type type, DataBuffer payload, @Nullable Object nativeMessage) {
        Assert.notNull((Object)((Object)type), (String)"'type' must not be null");
        Assert.notNull((Object)payload, (String)"'payload' must not be null");
        this.type = type;
        this.payload = payload;
        this.nativeMessage = nativeMessage;
    }

    public Type getType() {
        return this.type;
    }

    public DataBuffer getPayload() {
        return this.payload;
    }

    @Nullable
    public <T> T getNativeMessage() {
        return (T)this.nativeMessage;
    }

    public String getPayloadAsText() {
        return this.getPayloadAsText(StandardCharsets.UTF_8);
    }

    public String getPayloadAsText(Charset charset) {
        return this.payload.toString(charset);
    }

    public WebSocketMessage retain() {
        if (reactorNetty2Present) {
            return ReactorNetty2Helper.retain(this);
        }
        DataBufferUtils.retain((DataBuffer)this.payload);
        return this;
    }

    public void release() {
        DataBufferUtils.release((DataBuffer)this.payload);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof WebSocketMessage)) return false;
        WebSocketMessage that = (WebSocketMessage)other;
        if (!this.type.equals((Object)that.type)) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.payload, (Object)that.payload)) return false;
        return true;
    }

    public int hashCode() {
        return this.type.hashCode() * 29 + this.payload.hashCode();
    }

    public String toString() {
        return "WebSocket " + this.type.name() + " message (" + this.payload.readableByteCount() + " bytes)";
    }

    public static enum Type {
        TEXT,
        BINARY,
        PING,
        PONG;

    }

    private static class ReactorNetty2Helper {
        private ReactorNetty2Helper() {
        }

        static WebSocketMessage retain(WebSocketMessage message) {
            Object object = message.nativeMessage;
            if (object instanceof WebSocketFrame) {
                WebSocketFrame netty5Frame = (WebSocketFrame)object;
                WebSocketFrame frame = (WebSocketFrame)netty5Frame.send().receive();
                Netty5DataBuffer payload = ((Netty5DataBufferFactory)message.payload.factory()).wrap(frame.binaryData());
                return new WebSocketMessage(message.type, (DataBuffer)payload, frame);
            }
            DataBufferUtils.retain((DataBuffer)message.payload);
            return message;
        }
    }
}

