/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.AbstractLob$LobCtl;
import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.ByteUtil;
import java.io.Serializable;

public abstract class AbstractLob
extends Filterable
implements Serializable {
    public static final byte LOB_FLAG_BYTE = 0;
    public static final byte LOB_FLAG_CHAR = 1;
    public static final byte STORAGE_IN_ROW = 1;
    public static final byte STORAGE_OUT_ROW = 2;
    public static final byte STORAGE_LONG_ROW = 4;
    public static final int NBLOB_HEAD_STORAGE_FLAG = 0;
    public static final int NBLOB_HEAD_ID = 1;
    public static final int NBLOB_HEAD_LEN = 9;
    public static final int NBLOB_HEAD_OUTROW_GROUPID = 13;
    public static final int NBLOB_HEAD_OUTROW_FILEID = 15;
    public static final int NBLOB_HEAD_OUTROW_PAGENO = 17;
    public static final int NBLOB_HEAD_EX_TABLE_ID = 21;
    public static final int NBLOB_HEAD_EX_COL_ID = 25;
    public static final int NBLOB_HEAD_EX_ROW_ID = 27;
    public static final int NBLOB_HEAD_LONGROW_LEN = 35;
    public static final int NBLOB_HEAD_SIZE_INROW = 13;
    public static final int NBLOB_HEAD_SIZE_OUTROW = 21;
    public static final int NBLOB_HEAD_SIZE_EX = 43;
    public long id;
    public int storageType = 0;
    public int groupId = -1;
    public int fileId = -1;
    public int pageNo = -1;
    public int tabId;
    public int colId;
    public byte[] rowId;
    public int curFileId;
    public int curPageNo;
    public int curOffset;
    public long totalOffset;
    public boolean readOver = false;
    public DmdbConnection connection;
    public boolean local = true;
    public boolean updateable = true;
    public byte lobFlag;
    public long bytesLength = -1L;
    public long length = -1L;
    public boolean compatibleOracle = false;
    public boolean fetchAll = false;
    public boolean freed = false;
    public boolean modify = false;

    public AbstractLob(byte[] byArray, byte by, DmdbConnection dmdbConnection, Column column) {
        this(by, dmdbConnection);
        this.lobFlag = by;
        this.compatibleOracle = dmdbConnection.compatibleOracle();
        this.local = false;
        this.updateable = !column.readonly;
        this.tabId = column.lobTabId;
        this.colId = column.lobColId;
        this.storageType = ByteUtil.getByte(byArray, 0);
        this.id = ByteUtil.getLong(byArray, 1);
        this.bytesLength = this.storageType == 4 ? ByteUtil.getInt(byArray, 35) : ByteUtil.getInt(byArray, 9);
        if (this.getHeadSize() < 21) {
            return;
        }
        this.groupId = ByteUtil.getShort(byArray, 13);
        this.fileId = ByteUtil.getShort(byArray, 15);
        this.pageNo = ByteUtil.getInt(byArray, 17);
        this.curFileId = this.fileId;
        this.curPageNo = this.pageNo;
        this.curOffset = 0;
        this.totalOffset = 0L;
        if (this.getHeadSize() < 43) {
            return;
        }
        this.tabId = ByteUtil.getInt(byArray, 21);
        this.colId = ByteUtil.getShort(byArray, 25);
        this.rowId = ByteUtil.getBytes(byArray, 27, 8);
    }

    public AbstractLob(byte by, DmdbConnection dmdbConnection) {
        super(dmdbConnection, null);
        this.connection = dmdbConnection;
        this.lobFlag = by;
    }

    protected abstract void loadAllData();

    public long do_length() {
        this.checkFreed();
        if (this.length == -1L) {
            this.connection.checkClosed();
            this.length = this.connection.dbAccess.a(this);
        }
        return this.length;
    }

    public void do_free() {
        this.connection = null;
        this.freed = true;
    }

    public void checkFreed() {
        if (this.freed) {
            DBError.ECJDBC_LOB_FREED.throwz(new Object[0]);
        }
    }

    protected void checkConnection() {
        if (this.connection == null) {
            DBError.ECJDBC_LOB_FREED.throwz(new Object[0]);
        }
    }

    public boolean canOptimized(DmdbConnection dmdbConnection) {
        return dmdbConnection.lobOptimized && dmdbConnection == this.connection && this.storageType != 1 && !this.fetchAll && !this.local && !this.modify;
    }

    public AbstractLob$LobCtl buildCtlData() {
        return new AbstractLob$LobCtl(this);
    }

    public int getHeadSize() {
        int n2 = 0;
        n2 = this.connection.newLobFlag ? 43 : (this.storageType == 1 ? 13 : 21);
        return n2;
    }
}

