/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.RpcException;

public class FutureAdapter<V>
extends CompletableFuture<V> {
    private CompletableFuture<AppResponse> appResponseFuture;

    public FutureAdapter(CompletableFuture<AppResponse> future) {
        this.appResponseFuture = future;
        future.whenComplete((appResponse, t) -> {
            if (t != null) {
                if (t instanceof CompletionException) {
                    t = t.getCause();
                }
                this.completeExceptionally((Throwable)t);
            } else if (appResponse.hasException()) {
                this.completeExceptionally(appResponse.getException());
            } else {
                this.complete(appResponse.getValue());
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.appResponseFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.appResponseFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return super.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return (V)super.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RpcException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (V)super.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RpcException(e);
        }
    }
}

