/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.timeseries;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.timeseries.TimeSeriesProtocol;

public class TSMGetParams
implements IParams {
    private boolean withLabels;
    private String[] selectedLabels;

    public static TSMGetParams multiGetParams() {
        return new TSMGetParams();
    }

    public TSMGetParams withLabels(boolean withLabels) {
        this.withLabels = withLabels;
        return this;
    }

    public TSMGetParams withLabels() {
        return this.withLabels(true);
    }

    public TSMGetParams selectedLabels(String ... labels) {
        this.selectedLabels = labels;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.withLabels) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.WITHLABELS);
        } else if (this.selectedLabels != null) {
            args.add(TimeSeriesProtocol.TimeSeriesKeyword.SELECTED_LABELS);
            for (String label : this.selectedLabels) {
                args.add(label);
            }
        }
    }
}

