/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.rocketmq;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.ozhera.trace.etl.extension.rocketmq.RocketMQExtension;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMessageQueueWrapper {
    private static final Logger log = LoggerFactory.getLogger(ClientMessageQueueWrapper.class);
    private MessageQueue rocketMQMessageQueue;
    private BlockingQueue<MessageExt> clientMessageQueue;
    private RocketMQExtension producer;
    private ExecutorService executor;
    private boolean running = true;

    public ClientMessageQueueWrapper(MessageQueue rocketMQMessageQueue, BlockingQueue<MessageExt> clientMessageQueue, RocketMQExtension producer) {
        this.rocketMQMessageQueue = rocketMQMessageQueue;
        this.clientMessageQueue = clientMessageQueue;
        this.producer = producer;
        this.startExport();
        log.info(rocketMQMessageQueue.getBrokerName() + " - " + rocketMQMessageQueue.getQueueId() + " start");
    }

    public BlockingQueue<MessageExt> getClientMessageQueue() {
        return this.clientMessageQueue;
    }

    public void setClientMessageQueue(BlockingQueue<MessageExt> clientMessageQueue) {
        this.clientMessageQueue = clientMessageQueue;
    }

    public MessageQueue getRocketMQMessageQueue() {
        return this.rocketMQMessageQueue;
    }

    public void setRocketMQMessageQueue(MessageQueue rocketMQMessageQueue) {
        this.rocketMQMessageQueue = rocketMQMessageQueue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ClientMessageQueueWrapper) {
            ClientMessageQueueWrapper that = (ClientMessageQueueWrapper)o;
            return Objects.equals(this.rocketMQMessageQueue, that.rocketMQMessageQueue);
        }
        if (o instanceof MessageQueue) {
            MessageQueue queue = (MessageQueue)o;
            return Objects.equals(this.rocketMQMessageQueue, queue);
        }
        return false;
    }

    public int hashCode() {
        return this.rocketMQMessageQueue.hashCode();
    }

    private void startExport() {
        this.executor = Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(false);
            thread.setName("client-queue-exporter-" + this.rocketMQMessageQueue.getBrokerName() + "-" + this.rocketMQMessageQueue.getQueueId());
            return thread;
        });
        this.executor.submit(new ClientQueueExporter());
    }

    public void stopExport() {
        while (this.clientMessageQueue.size() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.error("sleep error : ", (Throwable)e);
            }
        }
        this.running = false;
        this.executor.shutdown();
        log.info(this.rocketMQMessageQueue.getBrokerName() + " - " + this.rocketMQMessageQueue.getQueueId() + " stopped");
    }

    private class ClientQueueExporter
    implements Runnable {
        private static final int CLIENT_QUEUE_BATCH_SEND_SIZE = 1000;
        private static final int CLIENT_QUEUE_SEND_GAP = 1000;
        private long lastSendTime = System.currentTimeMillis();

        @Override
        public void run() {
            while (ClientMessageQueueWrapper.this.running) {
                try {
                    int clientQueueSize = ClientMessageQueueWrapper.this.clientMessageQueue.size();
                    if (clientQueueSize > 0 && (clientQueueSize >= 1000 || System.currentTimeMillis() - this.lastSendTime >= 1000L)) {
                        ArrayList<MessageExt> list = new ArrayList<MessageExt>();
                        ClientMessageQueueWrapper.this.clientMessageQueue.drainTo(list);
                        ClientMessageQueueWrapper.this.producer.send(list, ClientMessageQueueWrapper.this.rocketMQMessageQueue);
                    }
                }
                catch (Throwable t) {
                    log.error("client queue exporter error : ", t);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    log.error("sleep error : ", (Throwable)e);
                }
            }
        }
    }
}

